/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "kldialog.h"

KLDialog::KLDialog(bool modal,WFlags flags) : QDialog( (QWidget *)0,0,modal,flags)
{
}

void KLDialog::setDeviceSize(unsigned long xSize, unsigned long ySize)
{
  ulong xOrigSize = xSize;
  ulong yOrigSize = ySize;
  ulong xCSize,yCSize; // rootChild sizes

  calcRWSize(xSize,ySize);
  getRCSize(xCSize,yCSize);

  // Must we do a resize ?
  if( showed && (xSize == (ulong)height()) && ((ulong)width() == ySize) && 
      (xCSize == xOrigSize) && (yCSize == yOrigSize) )
    return;
  resize(QSize(ySize,xSize));
  KLDevice::setDeviceSize(xOrigSize,yOrigSize);
}


bool KLDialog::refreshDisplay()
{
  if( !KLDevice::refreshDisplay())
    return false;
  // update();
  return true;
}

void KLDialog::show()
{
  if( showed ) 
    QDialog::show();
  else
    showDevice();
}

void KLDialog::hide()
{
  QDialog::hide();
}


bool KLDialog::createWindow()
{
  // Nothing to be done for us
  return true;
}


bool KLDialog::showWindow( KLDeviceShowinfo *deviceShowInfo )
{
  ulong xSize = deviceShowInfo->xSize;
  ulong ySize = deviceShowInfo->ySize;
  calcRWSize(xSize,ySize);
  bool ok = KLDevice::showWindow(deviceShowInfo);
  resize(QSize(ySize,xSize));
  QDialog::show();
  return ok;
}


void KLDialog::setLimits( KLDeviceShowinfo *deviceShowInfo )
{
  // Calcluate our real Dialog sizes 
  ulong maxX = deviceShowInfo->maxXSize;
  ulong maxY = deviceShowInfo->maxYSize;
  ulong minX = deviceShowInfo->minXSize;
  ulong minY = deviceShowInfo->minYSize;

  calcRWSize(minX,minY);
  calcRWSize(maxX,maxY);

  minX = KLMin(minX,QCOORD_MAX);
  minY = KLMin(minY,QCOORD_MAX);
  maxX = KLMin(maxX,QCOORD_MAX);
  maxY = KLMin(maxY,QCOORD_MAX);

  // And set the maximum/minimum sizes
  setMinimumSize(QSize(minY,minX));
  setMaximumSize(QSize(maxY,maxX));
}


void KLDialog::hideWindow()
{
  QDialog::hide();
  KLDevice::hideWindow();
}

void KLDialog::deleteWindow()
{
  KLDevice::deleteWindow();
  // notting to be done for us
}

void KLDialog::resizeEvent(QResizeEvent*e)
{
  static int i = 0;
  i++;
  if( i >= 5 )
    exit(0);
  if(showed) {
    ulong xSize = e->size().height();
    ulong ySize = e->size().width();
    calcDSize(xSize,ySize);
    setDeviceSize(xSize,ySize);
  }
  i--;
}

#include "kldialog.moc"

