%module Sock

%{
#include "KSocket.h"
#include <ksock.h>
%}

%include Types.i
%include Constants.i

%import Object.i


class _Socket : public Object
{
public:
    _Socket( const char *_path );
%name(_SocketInit)    _Socket( int _sock );
%name(_SocketHost)    _Socket( const char *_host, unsigned short int _port );
    ~_Socket();
    
    int socket() const { return sock; }

    void enableRead( bool );
    void enableWrite( bool );

    unsigned long getAddr();
    
    void slotWrite( int );
    void slotRead( int );

/*
signals:

    void readEvent( _Socket * );
    void writeEvent( _Socket * );
    void closeEvent( _Socket * );
*/
};


class _ServerSocket : public Object
{
public:
    _ServerSocket( const char *_path );
%name(_ServerSocketPort)    _ServerSocket( int _port );
    ~_ServerSocket();

    int socket() const { return sock; }
    unsigned short getPort();
    unsigned long getAddr();

    virtual void slotAccept( int );

/*
signals:

    void accepted( KSocket* );
*/
};

