#ifndef _KFile_H_
#define _KFile_H_

#include <Python.h>
#include <kfiledialog.h>
#include "Baseobject.h"


class _FileBaseDialog : public KFileBaseDialog, public BaseObject
{
  Q_OBJECT
public:
    _FileBaseDialog(const char *dirName, const char *filter= 0,
		QWidget *parent= 0, const char *name= 0, 
		bool modal = false, bool acceptURLs = true)
      : KFileBaseDialog(dirName,filter,parent,name,modal,acceptURLs){
      connect(this, SIGNAL(fileSelected(const char*)), this, SLOT(sigFileSelected(const char *)));
      connect(this, SIGNAL(fileHightlighted(const char *)), this, SLOT(sigFileHighlighted(const char *)));
      connect(this, SIGNAL(dirEntered(const char *)), this, SLOT(sigDirEntered(const char *)));
      connect(this, SIGNAL(historyUpdate(bool,bool)), this, SLOT(sigHistoryUpdate(bool,bool)));
    };
    ~_FileBaseDialog() {};
    
    KFileInfoContents *initFileList(QWidget *) {return NULL;};
    bool getShowFilter() { return false; };

    void _setDir(const char *name) {setDir(name,true);};
        
protected slots:

    void sigFileSelected(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileSelected", arg);  
       Py_DECREF(arg);
    };
    
    void sigFileHighlighted(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileHighlighted", arg);  
       Py_DECREF(arg);
    };
    
    void sigDirEntered(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("dirEntered", arg);  
       Py_DECREF(arg);
    };
    
    void sigHistoryUpdate(bool a, bool b) {
       PyObject *arg = Py_BuildValue("(i,i)",a,b);
       _emit("historyUpdate", arg);  
       Py_DECREF(arg);
    };
    
};


class _DirDialog : public KDirDialog, public BaseObject
{
  Q_OBJECT
public:
    _DirDialog(const char *url, QWidget *parent= 0, const char *name= 0)
      : KDirDialog(url,parent,name){
      connect(this, SIGNAL(fileSelected(const char*)), this, SLOT(sigFileSelected(const char *)));
      connect(this, SIGNAL(fileHightlighted(const char *)), this, SLOT(sigFileHighlighted(const char *)));
      connect(this, SIGNAL(dirEntered(const char *)), this, SLOT(sigDirEntered(const char *)));
      connect(this, SIGNAL(historyUpdate(bool,bool)), this, SLOT(sigHistoryUpdate(bool,bool)));
    };
    ~_DirDialog() {};
    
protected slots:

    void sigFileSelected(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileSelected", arg);  
       Py_DECREF(arg);
    };
    
    void sigFileHighlighted(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileHighlighted", arg);  
       Py_DECREF(arg);
    };
    
    void sigDirEntered(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("dirEntered", arg);  
       Py_DECREF(arg);
    };
    
    void sigHistoryUpdate(bool a, bool b) {
       PyObject *arg = Py_BuildValue("(i,i)",a,b);
       _emit("historyUpdate", arg);  
       Py_DECREF(arg);
    };
    
};


class _FileDialog : public KFileDialog, public BaseObject
{
  Q_OBJECT
public:
    _FileDialog(const char *dirName, const char *filter= 0,
		QWidget *parent= 0, const char *name= 0, 
		bool modal = false, bool acceptURLs = true)
      : KFileDialog(dirName,filter,parent,name,modal,acceptURLs){
      connect(this, SIGNAL(fileSelected(const char*)), this, SLOT(sigFileSelected(const char *)));
      connect(this, SIGNAL(fileHightlighted(const char *)), this, SLOT(sigFileHighlighted(const char *)));
      connect(this, SIGNAL(dirEntered(const char *)), this, SLOT(sigDirEntered(const char *)));
      connect(this, SIGNAL(historyUpdate(bool,bool)), this, SLOT(sigHistoryUpdate(bool,bool)));
    };
    ~_FileDialog() {};
    
protected slots:

    void sigFileSelected(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileSelected", arg);  
       Py_DECREF(arg);
    };
    
    void sigFileHighlighted(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("fileHighlighted", arg);  
       Py_DECREF(arg);
    };
    
    void sigDirEntered(const char *file) {
       PyObject *arg = Py_BuildValue("(s)",file);
       _emit("dirEntered", arg);  
       Py_DECREF(arg);
    };
    
    void sigHistoryUpdate(bool a, bool b) {
       PyObject *arg = Py_BuildValue("(i,i)",a,b);
       _emit("historyUpdate", arg);  
       Py_DECREF(arg);
    };
    
};

#endif
