%module Button


%{
#include "Object.h"
#include "Button.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i


class Button : public QWidget
{

public:
    Button(QWidget *parent=0, const char *name=0 );
    ~Button();
	
    const char *text() const;
    void	setText( const char * );
    const QPixmap *pixmap() const;
    void	setPixmap( const QPixmap & );

    int		accel()	const;
    void	setAccel( int );

    bool	isToggleButton() const;

    bool	isDown() const;
    bool	isOn() const;

    bool	autoResize() const;
    void	setAutoResize( bool );

    bool	autoRepeat() const;
    void	setAutoRepeat( bool );

    void	animateClick();

/*
signals:
    void	pressed();
    void	released();
    void	clicked();
    void	toggled( bool );
*/

};
