%module image

%{
#include <qimage.h>
%}

%import Baseobject.i


class QImage : public BaseObject
{
public:
    enum Endian { IgnoreEndian, BigEndian, LittleEndian };

    QImage();
%name(QImageSize)    QImage( const QSize&, int depth, int numColors=0,
	    Endian bitOrder=IgnoreEndian );
%name(QImageFile)    QImage( const char *fileName, const char *format=0 );
%name(QImageCopy)    QImage( const QImage & );
   ~QImage();

    void	detach();
    QImage	copy()		const;

    bool	isNull()	const	{ return data->bits == 0; }

    int		width()		const	{ return data->w; }
    int		height()	const	{ return data->h; }
    QSize	size()		const	{ return QSize(data->w,data->h); }
    QRect	rect()		const	{ return QRect(0,0,data->w,data->h); }
    int		depth()		const	{ return data->d; }
    int		numColors()	const	{ return data->ncols; }
    Endian 	bitOrder()	const	{ return (Endian) data->bitordr; }

    QRgb	color( int i )	const;
    void	setColor( int i, QRgb c );
    void	setNumColors( int );

    bool	hasAlphaBuffer() const;
    void	setAlphaBuffer( bool );

    unsigned char      *bits()		const;
    unsigned char      *scanLine( int ) const;
    unsigned char     **jumpTable()	const;
    QRgb       *colorTable()	const;
    int		numBytes()	const;
    int		bytesPerLine()	const;

    bool	create( const QSize&, int depth, int numColors=0,
			Endian bitOrder=IgnoreEndian );
    void	reset();

    void	fill( unsigned int pixel );

    QImage	convertDepth( int ) const;
%name(convertDepthFlags)    QImage	convertDepth( int, int conversion_flags ) const;
    QImage	convertBitOrder( Endian ) const;

    QImage	createAlphaMask( int conversion_flags ) const;
    QImage	createHeuristicMask( bool clipTight=TRUE ) const;

    static Endian systemBitOrder();
    static Endian systemByteOrder();

    static const char *imageFormat( const char *fileName );
    static QStrList inputFormats();
    static QStrList outputFormats();

    bool	load( const char *fileName, const char *format=0 );
    bool	loadFromData( const unsigned char *buf, unsigned int len,
			      const char *format=0 );
    bool	save( const char *fileName, const char *format ) const;

    bool	valid( int x, int y ) const;
    int		pixelIndex( int x, int y ) const;
    QRgb	pixel( int x, int y ) const;
    void	setPixel( int x, int y, unsigned int index_or_rgb );
};
