#include "Menubar.h"
#include "Menubar.moc"


MenuBar::MenuBar(QWidget *parent=0, const char *name=0)
  : QMenuBar(parent,name), BaseObject()
{
  connect(this, SIGNAL(activated(int)), this, SLOT(sigActivated(int)));
  connect(this, SIGNAL(highlighted(int)), this, SLOT(sigHighlighted(int)));
}


MenuBar::~MenuBar()
{
}


int MenuBar::_insertItem(const char *text, PyObject *slot, int accel=0) 
{
  int id = insertItem(text);

  if (accel)
    setAccel(accel, id);

  _connectItem(id, slot);

  return id;
}


int MenuBar::_insertPixmap(const QPixmap &pixmap, PyObject *slot, int accel=0) 
{
  int id = insertItem(pixmap);

  if (accel)
    setAccel(accel, id);

  _connectItem(id, slot);

  return id;
}


int MenuBar::_insertItemPixmap(const QPixmap &pixmap,const char *text, PyObject *slot, int accel=0) 
{
  int id = insertItem(pixmap,text);

  if (accel)
    setAccel(accel, id);

  _connectItem(id, slot);

  return id;
}


void MenuBar::_connectItem(int id, PyObject *slot) 
{
  QList<PyObject> *list = connections[id];

  if (!list)
  {
    list = new QList<PyObject>;
    connections.insert(id, list);
  }

  Py_INCREF(slot);
  list->append(slot);      
}


void MenuBar::_disconnectItem(int id, PyObject *slot) 
{
  QList<PyObject> *list = connections[id];

  if (list)
  {
    int index = list->find(slot);
    if (index != -1)
    {
      list->remove(index);
      Py_DECREF(slot);
    }
  }
}


void MenuBar::sigActivated(int id) 
{
   QList<PyObject> *list = connections[id];

   if (list)
   {
     for (PyObject *it = list->first(); it != 0; it=list->next())
     {
       PyObject *result = PyEval_CallObject(it, 0);
       if (!result)
         PyErr_Print();
       Py_XDECREF(result);
     }
   } 

   PyObject *arg = Py_BuildValue("(i)", id); 
   _emit("activated", arg);
   Py_DECREF(arg);
}


void MenuBar::sigHighlighted(int id) 
{
   PyObject *arg = Py_BuildValue("(i)", id); 
   _emit("highlighted", arg);
   Py_DECREF(arg);
}
