/*****************************************************************************
 *** sujoin.cpp
 ***
 *** Copyright (c) 1998 Susanne Cech <scech@edu.uni-klu.ac.at>
 ***
 *** Requires the Qt widget libraries, available at no cost at
 *** http://www.troll.no/
 ***
 ***  This program is free software; you can redistribute it and/or modify
 ***  it under the terms of the GNU General Public License as published by
 ***  the Free Software Foundation; either version 2 of the License, or
 ***  (at your option) any later version.
 ***
 ***  This program is distributed in the hope that it will be useful,
 ***  but WITHOUT ANY WARRANTY; without even the implied warranty of
 ***  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ***  GNU General Public License for more details.
 ***
 ***  You should have received a copy of the GNU General Public License
 ***  along with this program; if not, write to the Free Software
 ***  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ***
 *****************************************************************************/

#include "sujoin.h"
#include "sujoin.moc"
#include <qdict.h>
#include <qapp.h>
#include <unistd.h>

#define TRENN "\" \"" 


/*****************************************************************************/
/********************   CLASS JoinAttrib   ***********************************/
/*****************************************************************************/

JoinAttrib::JoinAttrib( Serialize* parent, const char* name ):
 Serialize( parent,name ) {

  _codePA=0;
};
     
/*****************************************************************************/
void JoinAttrib::setCodePA( int codePA ) {
  _codePA=codePA;
  emit codePAChanged();
};

/*****************************************************************************/
QList<VarTuple> JoinAttrib::objState() const {
  QList<VarTuple> ql;
  ql.append( new VarTuple("_codePA",_codePA) );
  return ql;
};

/*****************************************************************************/
void JoinAttrib::setFixedOrderObjState( QList<VarTuple> state ) {
   state.first()->storeValueTo(_codePA);
};

/*****************************************************************************/
void JoinAttrib::setObjState( QList<VarTuple> state ) {
  QDict<VarTuple> dict;
  VarTuple* vt;

  for(vt=state.first();vt != 0;vt=state.next()) {
     if ( vt->tag().isEmpty() )
        fatal("got a VarTuple with an empty VarTag-Field!");
     dict.replace(vt->tag(),state.current());
  }
  if ( (vt = dict["_codePA"]) != 0 ) 
    vt->storeValueTo(_codePA);
};
 
 
/*****************************************************************************/
/********************   CLASS PrincipeActif   ********************************/
/*****************************************************************************/

PrincipeActif::PrincipeActif( JoinAttrib* parent, const char* name ):
 JoinAttrib( parent,name ) {

  _name="";
};

/*****************************************************************************/
void PrincipeActif::setName( QString name ) {
  _name=name;
  emit nameChanged();
};

/*****************************************************************************/
QList<VarTuple> PrincipeActif::objState() const {

  QList<VarTuple> state = JoinAttrib::objState();   // Supercall
  state.append( new VarTuple( "_name", _name));
  return state;
};

/*****************************************************************************/
void PrincipeActif::setFixedOrderObjState( QList<VarTuple> state ) {  
  int nrJA = JoinAttrib::objState().count();

  QList<VarTuple> ql;
  state.first();
  for ( int i=0; i < nrJA; i++ )
    ql.append( state.take()); 
  JoinAttrib::setFixedOrderObjState( ql);   // Supercall

  state.first()->storeValueTo( _name);
};

/*****************************************************************************/
void PrincipeActif::setObjState( QList<VarTuple> state ) {
  QDict<VarTuple> dict;

  JoinAttrib::setObjState( state);
  VarTuple* vt;
  
  for(vt=state.first();vt != 0;vt=state.next()) {
     if ( vt->tag().isEmpty() )
        fatal("got a VarTuple with an empty VarTag-Field!");
     dict.replace(vt->tag(),state.current());
  }
  if ( (vt = dict["_name"]) != 0 )
    vt->storeValueTo( _name);
};
 

/*****************************************************************************/
/********************   CLASS BelongsTo   ************************************/
/*****************************************************************************/

BelongsTo::BelongsTo( JoinAttrib* parent, const char* name ):JoinAttrib ( parent, name ) { 
  
   _codeMed=0;
};

/*****************************************************************************/
void BelongsTo::setCodeMed( int codeMed ) {
  _codeMed=codeMed;
  emit codeMedChanged();
};

/*****************************************************************************/
QList<VarTuple> BelongsTo::objState() const {
  QList<VarTuple> state = JoinAttrib::objState();   // Supercall
  state.append( new VarTuple( "_codeMed", _codeMed));
  return state;
};

/*****************************************************************************/
void BelongsTo::setFixedOrderObjState( QList<VarTuple> state ) {
  int nrJA = JoinAttrib::objState().count();

  QList<VarTuple> ql;
  state.first();
  for ( int i=0; i < nrJA; i++ )
    ql.append( state.take()); 
  JoinAttrib::setFixedOrderObjState( ql);

  state.first()->storeValueTo( _codeMed);
};

/*****************************************************************************/
void BelongsTo::setObjState( QList<VarTuple> state ) {
  JoinAttrib::setObjState( state);
  QDict<VarTuple> dict;
  VarTuple* vt;
   for(vt=state.first();vt != 0;vt=state.next()) {
     if ( vt->tag().isEmpty() )
        fatal("got a VarTuple with an empty VarTag-Field!");
     dict.replace(vt->tag(),state.current());
  }
  if ( (vt = dict["_codeMed"]) ) 
      vt->storeValueTo(_codeMed);
};


/*****************************************************************************/
/********************   CLASS JoinRes   **************************************/
/*****************************************************************************/

JoinRes::JoinRes( JoinAttrib* parent, const char* name) :
  PrincipeActif(parent,name), BelongsTo(parent,name) {

};

/*****************************************************************************/
QList<VarTuple> JoinRes::objState() const {
  QList<VarTuple> statePA = PrincipeActif::objState();   // Supercall 1
  QList<VarTuple> stateBt = BelongsTo::objState();       // Supercall 2
  for (VarTuple *vt = stateBt.first(); vt != NULL; vt = stateBt.next()) {
    statePA.append(vt);
  }
  return statePA;
};

/*****************************************************************************/
void JoinRes::setFixedOrderObjState( QList<VarTuple> state ) {
  int nrPA = PrincipeActif::objState().count();   // Supercall 1
  int nrBt = BelongsTo::objState().count();       // Supercall 2

  QList<VarTuple> statePA;
  state.first();
  for ( int i=0; i < nrPA; i++ )
    statePA.append( state.take());
  PrincipeActif::setFixedOrderObjState( statePA);

  QList<VarTuple> stateBt;
  state.first();
  for ( int i=0; i < nrBt; i++ )
    stateBt.append(state.take());
  BelongsTo::setFixedOrderObjState( stateBt);
};

/*****************************************************************************/
void JoinRes::setObjState( QList<VarTuple> state ) {
  PrincipeActif::setObjState(state);   // Supercall 1
  BelongsTo::setObjState(state);       // Supercall 2
};


/*****************************************************************************/
/********************   CLASS TransferComplete   *****************************/
/*****************************************************************************/

/* yet implemented in sujoin.h 
 */


/*****************************************************************************/
/********************   CLASS SuKPvm   ***************************************/
/*****************************************************************************/

int SuKPvm::hash( int i) {
  return ((i * 997) % NRPROCS);
};

/*****************************************************************************/
void SuKPvm::guiInit () {

  this->setFixedSize( 420, 200);
  quit = new QPushButton( "QUIT", this, "quit");     CHECK_PTR(quit);
  quit->setEnabled( FALSE);
  quit->setGeometry(290,this->height()-40,120,30);
  quit->setFont( QFont( "Helvetica", 18, QFont::Bold));  
  connect( quit, SIGNAL(clicked()), qApp, SLOT(quit()));

  paBOX = new QGroupBox( "Principe Actif", this, "paBOX");   CHECK_PTR(paBOX);
  paBOX->setGeometry(10,10,120,100);
  paLCD = new QLCDNumber(4, paBOX, "paLCD");    CHECK_PTR(paLCD);
  paLCD->setSegmentStyle(QLCDNumber::Filled);
  paLCD->display(0);
  paLCD->setGeometry( 10, 20, 100, 70);
  paLCD->setBackgroundColor( QColor(115,153,144));

  btBOX = new QGroupBox( "Belongs To", this, "btBOX");   CHECK_PTR(btBOX);
  btBOX->setGeometry(150,10,120,100);
  btLCD = new QLCDNumber(4, btBOX, "btLCD");    CHECK_PTR(btLCD);
  btLCD->setSegmentStyle(QLCDNumber::Filled);
  btLCD->display(0);
  btLCD->setGeometry( 10, 20, 100, 70);
  btLCD->setBackgroundColor( QColor(115,153,144));
  
  jrBOX = new QGroupBox( "Join Result", this, "jrBOX");   CHECK_PTR(jrBOX);
  jrBOX->setGeometry(290,10,120,100);
  jrLCD = new QLCDNumber(4, jrBOX, "jrLCD");    CHECK_PTR(jrLCD);
  jrLCD->setSegmentStyle(QLCDNumber::Filled);
  jrLCD->display(0);
  jrLCD->setGeometry( 10, 20, 100, 70);
  jrLCD->setBackgroundColor( QColor( 110,116,153));

  timeLCD = new QLCDNumber(9, this, "timeLCD");
  timeLCD->setGeometry(150,this->height()-40,120,30);
  timeLCD->setSegmentStyle(QLCDNumber::Filled);
  timeLCD->display("00:00:000");

  this->show();
};

/*****************************************************************************/
void SuKPvm::sendPrincipeActif() {
  fin.setName( PA_FILE);
  if ( !fin.open(IO_ReadOnly) )            // file opened successfully
    fatal("Can't open Input-file");
  tstream.setDevice( &fin);                 // use text stream 
  int n=0;
  PrincipeActif* pa = new PrincipeActif();
  while ( !tstream.eof() ) {                // until end of file...
    s=tstream.readLine().stripWhiteSpace(); // line excluding '\n'   
    if ( !s.isEmpty() ) { 
      paLCD->display(paLCD->intValue() + 1);
      n++;
      // codePA
      sscanf(s, "\"%d\"%*s", &i);             
      pa->setCodePA( i);
      int pos = s.find( TRENN);
      // name
      i = pos+strlen(TRENN);
      pa->setName( s.mid(i, s.length()-i-1));
      // send to child
      this->send(children.at(this->hash(pa->codePA())), pa, n);
    } //if (!s.isEmpty())           
  } //while
  fin.close();
  TransferComplete tc;                     // all data has been sent
  for ( i=0; i<NRPROCS; i++)
    this->send( children.at(i),&tc,999);    // send transfer complete!
};

/*****************************************************************************/
void SuKPvm::sendBelongsTo() {     
  fin.setName( BT_FILE);
  if ( !fin.open(IO_ReadOnly) )           // file opened successfully 
    fatal("Can't open Input-file");
  tstream.setDevice( &fin);
  int n=0;
  BelongsTo* bt = new BelongsTo();
  while ( !tstream.eof() ) {              // until end of file...
    s=tstream.readLine().stripWhiteSpace();
    if ( !s.isEmpty() ) { 
      btLCD->display(btLCD->intValue() + 1);
      n++;
      int i2;
      sscanf(s, "\"%d\" \"%d\"", &i, &i2);             
      bt->setCodeMed(i);
      bt->setCodePA(i2);
      // send to child
      this->send(children.at(this->hash(bt->codePA())), bt, n);
    } //if (!s.isEmpty())           
  } //while
  fin.close();
  TransferComplete tc;                  // all data has been sent
  for ( i=0; i<NRPROCS; i++ )
    this->send(children.at(i), &tc,998);
};

/*****************************************************************************/
SuKPvm::SuKPvm( KPvm *parent=0, const char *name=0 ) : KPvm( parent, name) {

  // part both of parent and child
  time= new QTime(0,0,0,0);       // 0 hrs, 0 min, 0 secs, 0 ms
  time->start();
  this->guiInit();
  this->changeCheckInterval(10);  // milisecs

  // part of children
  if ( this->hasPvmParent() ) {
    s.sprintf("CHILD t%x on [%s]",this->tid(),this->hostName().data() );
    this->setCaption( s);
    paLCD->setBackgroundColor( QColor(110,116,153));
    btLCD->setBackgroundColor( QColor(110,116,153));
    jrLCD->setBackgroundColor( QColor(115,153,144));
    debug("i'm child t%x from t%x",this->tid(),this->pvmParent()->tid());
    _pa = new QDict<PrincipeActif>(997);
    connect( 
      this, 
      SIGNAL( dataReceived( QString, QList<VarTuple>, int, KPvmEntity*)),
      this, 
      SLOT( childHandleRecvPA( QString, QList<VarTuple>, int, KPvmEntity*)));
  }
     
  // part of parent
  else {
    runProcs = NRPROCS;
    s.sprintf("PARENT t%x on [%s]",this->tid(),this->hostName().data() );
    this->setCaption( s);

    // spawn NRPROCS children
    children = this->spawn("sujoin",environ,PvmDataDefault,"",NRPROCS);

    debug("i'm parent %x", this->tid());
    debug("$DISPLAY=[%s]",getenv("DISPLAY") );
    for ( i=0; i<NRPROCS; i++)
      debug("started child t%x on [%s]", children.at(i)->tid(),
          children.at(i)->hostName().data());

    this->sendPrincipeActif();
    connect( 
      this, 
      SIGNAL(dataReceived( QString,QList<VarTuple>,int,KPvmEntity*)),
      this,
      SLOT(parentHandleReceivedData(QString,QList<VarTuple>,int,KPvmEntity*)));
    this->sendBelongsTo();
    fout.setName(JOIN_RES);
    if ( ! fout.open(IO_WriteOnly) )
        fatal("Can't open Output-file");
    tstream.setDevice( &fout);   
  }//if parent
};//Constructor


/*****************************************************************************/
QString itos(int n) {
  QString s;
  s.sprintf("%i",n);
  return s;
};
  
/*****************************************************************************/
void SuKPvm::childHandleRecvPA( 
  QString className, QList<VarTuple> objState, int, KPvmEntity *) {

  if ( className == "PrincipeActif" ) {
    paLCD->display(paLCD->intValue() + 1);
    PrincipeActif* pa = new PrincipeActif();  CHECK_PTR(pa);
    pa->setFixedOrderObjState(objState);
    _pa->insert( itos( pa->codePA()), pa);
    return;
  }
  if ( className == "TransferComplete" ) { 
    disconnect(this);
    connect( 
     this, SIGNAL( dataReceived( QString, QList<VarTuple>, int, KPvmEntity*)),
     this, SLOT( childHandleRecvBt( QString,QList<VarTuple>,int,KPvmEntity*)));
    return; 
  }
};

/*****************************************************************************/
void SuKPvm::childHandleRecvBt( 
  QString className, QList<VarTuple> objState, int, KPvmEntity *) {

  if ( className == "BelongsTo" ) { // probe 
    btLCD->display(btLCD->intValue() + 1);
    PrincipeActif *pa;
    BelongsTo     *bt = new BelongsTo();             CHECK_PTR(bt);
    JoinRes      *res = new JoinRes();               CHECK_PTR(res);
    QList<PrincipeActif> padl;  // princip actif dummy list
    bt->setFixedOrderObjState(objState);

    while ( (pa = _pa->find( itos(bt->codePA()) ) ) != NULL ) {
      if (_pa->remove( itos(bt->codePA())))   // sichere tupel
         padl.append(pa);
      // JoinRes-Objekt zum Master schicken
      res->setObjState( pa->objState());
      res->setObjState( bt->objState());
      this->send( this->pvmParent(), res, 55);
      jrLCD->display(jrLCD->intValue() + 1);      
    }// while
    for (PrincipeActif *apa=padl.first();apa != NULL; apa = padl.next()) 
       _pa->insert( itos( apa->codePA()), apa);
  }//if
  
  if ( className == "TransferComplete" ) {
    TransferComplete tc;
    this->send(this->pvmParent(),&tc,997);
    quit->setEnabled( TRUE);
    int i = time->elapsed();
    int msec = i % 1000;  i /= 1000;
    int sec  = i % 60;
    int min  = i / 60;
    s.sprintf("%2d:%2d:%3d", min , sec, msec);
    timeLCD->display(s);
  }
};

/*****************************************************************************/
void SuKPvm::parentHandleReceivedData( 
  QString className, QList<VarTuple> objState, int, KPvmEntity *) {
  
  if ( className == "JoinRes" ) {
    jrLCD->display(jrLCD->intValue() + 1);

    JoinRes* res = new JoinRes();  CHECK_PTR(res);
    res->setFixedOrderObjState(objState);
    // write to File
    tstream <<"\""<<res->codePA()<<TRENN<<res->codeMed()<<TRENN << res->name() <<"\"\n";
    return;
  }

  if ( className == "TransferComplete" ) {
    runProcs--;
    if ( runProcs == 0) {
       fout.close();  // close output file
       quit->setEnabled( TRUE);
       int i = time->elapsed();
       int msec = i % 1000;  i /= 1000;
       int sec  = i % 60;
       int min  = i / 60;
       s.sprintf("%2d:%2d:%3d", min , sec, msec);
       timeLCD->display(s);
    }
    return;
  }
};


/*****************************************************************************/
void SuKPvm::closeEvent( QCloseEvent *) {
  // ALT-C or close-Window
  this->exit();
};


/*****************************************************************************/
/********************   MAIN   ***********************************************/
/*****************************************************************************/

int main (int argc, char **argv) {
  QApplication qapp( argc, argv);
  SuKPvm suKPvm;
  qapp.setMainWidget( &suKPvm);
  qapp.exec();
};
