/////////////////////////////////////////////////////////////////////////////
//
// Directory plugin.
//
// Time-stamp: <97/05/06 03:57:43 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////
  
#ifndef _PLUGIN_H_
#define _PLUGIN_H_

#include "kplugin.h"

/// DirPlugin: Directory listing plugin.
/** 
  Plugin type: input.

  Description:
    This plugin retreives directory listing.
  
  Output MIME types:
    MIME type             Description
    -------------------------------------------------------------------
    text/directory        List of files in special data type (see mimetype.h)
    text/plain            Like ls

  Options:
    Name            Type                Description
    -------------------------------------------------------------------
    "dir"           (char *)            Directory to work with.
    "dots"          bool                Output dot files ?
    "regexp"        (char *)            Filter the files with this mask.
  */
class DirPlugin : public KPlugin
{
  Q_OBJECT

public:
  /// Constructor
  /** 
    Constructs DirPlugin
    */
  DirPlugin();
  ~DirPlugin();

  virtual int start();

protected:
  virtual int callOptionMemberFunction(int index, void *arg);

  int  setDirectory(void *);
  int  getDirectory(void *);
  int  setDots(void *);
  int  getDots(void *);
  
private:
  QString  m_directory;
  bool     m_dots;

  // Array of pointers to actions - used in callOptionMemberFunction()
  typedef int (DirPlugin::*MemberFunction)(void *);
  MemberFunction *m_option;

  // Array of pointers to input handlers - used in callInputMemberFunction()
  MemberFunction *m_input;
};



/// Create new plugin instance.
/** 
  C function used by application to access this plugin.
  The application must call dlopen("full_path_to_plugin"). And then 
  dlsym(handle, "initInstance). Then each call to initInstance() will
  create and return new copy of the plugin object.
  */
extern "C" KPlugin *initInstance()
{
  return (KPlugin *)(new DirPlugin);
}

#endif // _PLUGIN_H_
