/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QFileInfo.h"

#include <qdir.h>
qt_QFileInfo *qt_new_QFileInfo()

{
	return (qt_QFileInfo *) new QFileInfo( );
}

qt_QFileInfo *qt_new_QFileInfo1(char* file)

{
	return (qt_QFileInfo *) new QFileInfo( (char*)file );
}

qt_QFileInfo *qt_new_QFileInfo2(qt_QFile * arg1)

{
	return (qt_QFileInfo *) new QFileInfo( (QFile&)*arg1 );
}

qt_QFileInfo *qt_new_QFileInfo3(qt_QDir * arg1,char* fileName)

{
	return (qt_QFileInfo *) new QFileInfo( (QDir&)*arg1,(char*)fileName );
}

qt_QFileInfo *qt_new_QFileInfo4(qt_QFileInfo * arg1)

{
	return (qt_QFileInfo *) new QFileInfo( (QFileInfo&)*arg1 );
}

void qt_del_QFileInfo (qt_QFileInfo *p)
{
delete (QFileInfo*) p;
}

void qt_QFileInfo_setFile( qt_QFileInfo *instPointer,char* file){
	((QFileInfo *)instPointer)->setFile((char* )file);
}
void qt_QFileInfo_setFile1( qt_QFileInfo *instPointer,qt_QFile * arg1){
	((QFileInfo *)instPointer)->setFile((QFile& )*arg1);
}
void qt_QFileInfo_setFile2( qt_QFileInfo *instPointer,qt_QDir * arg1,char* fileName){
	((QFileInfo *)instPointer)->setFile((QDir& )*arg1,(char* )fileName);
}
int qt_QFileInfo_exists( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->exists();
}
void qt_QFileInfo_refresh( qt_QFileInfo *instPointer){
	((QFileInfo *)instPointer)->refresh();
}
int qt_QFileInfo_caching( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->caching();
}
void qt_QFileInfo_setCaching( qt_QFileInfo *instPointer,int arg1){
	((QFileInfo *)instPointer)->setCaching((bool )arg1);
}
char* qt_QFileInfo_filePath( qt_QFileInfo *instPointer){
	return (char*)((QFileInfo *)instPointer)->filePath();
}
qt_QString * qt_QFileInfo_fileName( qt_QFileInfo *instPointer){
	return (qt_QString *)new QString(((QFileInfo *)instPointer)->fileName());
}
qt_QString * qt_QFileInfo_absFilePath( qt_QFileInfo *instPointer){
	return (qt_QString *)new QString(((QFileInfo *)instPointer)->absFilePath());
}
qt_QString * qt_QFileInfo_baseName( qt_QFileInfo *instPointer){
	return (qt_QString *)new QString(((QFileInfo *)instPointer)->baseName());
}
qt_QString * qt_QFileInfo_extension( qt_QFileInfo *instPointer){
	return (qt_QString *)new QString(((QFileInfo *)instPointer)->extension());
}
qt_QString * qt_QFileInfo_dirPath( qt_QFileInfo *instPointer,int absPath){
	return (qt_QString *)new QString(((QFileInfo *)instPointer)->dirPath((bool )absPath));
}
qt_QDir * qt_QFileInfo_dir( qt_QFileInfo *instPointer,int absPath){
	return (qt_QDir *)new QDir(((QFileInfo *)instPointer)->dir((bool )absPath));
}
int qt_QFileInfo_isReadable( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isReadable();
}
int qt_QFileInfo_isWritable( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isWritable();
}
int qt_QFileInfo_isExecutable( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isExecutable();
}
int qt_QFileInfo_isRelative( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isRelative();
}
int qt_QFileInfo_convertToAbs( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->convertToAbs();
}
int qt_QFileInfo_isFile( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isFile();
}
int qt_QFileInfo_isDir( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isDir();
}
int qt_QFileInfo_isSymLink( qt_QFileInfo *instPointer){
	return (int)((QFileInfo *)instPointer)->isSymLink();
}
qt_QString * qt_QFileInfo_readLink( qt_QFileInfo *instPointer){
	return (qt_QString *)new QString(((QFileInfo *)instPointer)->readLink());
}
char* qt_QFileInfo_owner( qt_QFileInfo *instPointer){
	return (char*)((QFileInfo *)instPointer)->owner();
}
unsigned int qt_QFileInfo_ownerId( qt_QFileInfo *instPointer){
	return (unsigned int)((QFileInfo *)instPointer)->ownerId();
}
char* qt_QFileInfo_group( qt_QFileInfo *instPointer){
	return (char*)((QFileInfo *)instPointer)->group();
}
unsigned int qt_QFileInfo_groupId( qt_QFileInfo *instPointer){
	return (unsigned int)((QFileInfo *)instPointer)->groupId();
}
int qt_QFileInfo_permission( qt_QFileInfo *instPointer,int permissionSpec){
	return (int)((QFileInfo *)instPointer)->permission((int )permissionSpec);
}
unsigned int qt_QFileInfo_size( qt_QFileInfo *instPointer){
	return (unsigned int)((QFileInfo *)instPointer)->size();
}
qt_QDateTime * qt_QFileInfo_lastModified( qt_QFileInfo *instPointer){
    QDateTime dt=((QFileInfo *)instPointer)->lastModified();
    return (qt_QDateTime *)new QDateTime (dt.date(),dt.time());
}
qt_QDateTime * qt_QFileInfo_lastRead( qt_QFileInfo *instPointer){
    QDateTime dt=((QFileInfo *)instPointer)->lastRead();
    return (qt_QDateTime *)new QDateTime (dt.date(),dt.time());
}
