class ComboBox : public Widget
{
public:
  ComboBox(int rw, Widget *parent=0, const char *name=0);
  %name(ComboBoxOld) ComboBox(Widget *parent=0, const char *name=0);
  ~ComboBox();

  int count() const;
  
  void insertList(PyObject *list);
  // allows a list of text/pixmaps to be inserted
  
  %name(insertText) void insertItem( const char *text, int index=-1 );
  %name(insertPixmap) void insertItem( const QPixmap &pixmap, int index=-1 );
  
  void removeItem( int index );
  void clear();
  
  const char *currentText() const;
  const char *text( int index ) const;
  const QPixmap *pixmap( int index ) const;
  
  %name(changeText) void changeItem( const char *text, int index );
  %name(changePixmap) void changeItem( const QPixmap &pixmap, int index );
  
  int currentItem() const;
  void setCurrentItem( int index );
  
  bool autoResize()    const;
  void setAutoResize( int );
  QSize sizeHint() const;
  
  void setBackgroundColor( const QColor & );
  void setPalette( const QPalette & );
  void setFont( const QFont & );
  void setEnabled( int );
  
  void setSizeLimit( int );
  int sizeLimit() const;
  
  void setMaxCount( int );
  int maxCount() const;
  
  enum Policy { NoInsertion, AtTop, AtCurrent, AtBottom,
		AfterCurrent, BeforeCurrent };
  
  void setInsertionPolicy( ComboBox::Policy policy );
  ComboBox::Policy insertionPolicy() const;
  
  //signals:
  //  void        activated( int index );
  //  void        highlighted( int index );
  //  void        activated( const char * );
  //  void        highlighted( const char * );
};

