/****************************************************************************************
 * Copyright (c) 2008 Nikolaj Hald Nielsen <nhn@kde.org>                                *
 * Copyright (c) 2005 Max Howell <max.howell@methylblue.com>                            *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef LONGMESSAGEWIDGET_H
#define LONGMESSAGEWIDGET_H

#include "PopupWidget.h"


class CountdownFrame : public QFrame
{
public:
    explicit CountdownFrame( QWidget *parent = nullptr );
    void setFilledRatio( float filled ); // 0 to 1

    void paintEvent( QPaintEvent *e ) override;

protected:
    float m_filled;
};

/** A widget for displaying a long message as an overlay
*/
class LongMessageWidget : public PopupWidget
{
    Q_OBJECT
public:
    explicit LongMessageWidget( const QString &message );

    ~LongMessageWidget() override;

Q_SIGNALS:
    void closed();

protected:
    void timerEvent( QTimerEvent * ) override;

private Q_SLOTS:
    void close();

private:
    CountdownFrame *m_countdownFrame;
    int m_counter;
    int m_timeout;
    int m_timerId;

};

#endif
