/*
 * automount.h
 *
 * Header file for automounter modules
 *
 */

#ifndef AUTOMOUNT_H
#define AUTOMOUNT_H

#include <paths.h>

#ifndef _PATH_MOUNT
#define _PATH_MOUNT "/bin/mount"
#endif
#ifndef _PATH_UMOUNT
#define _PATH_UMOUNT "/bin/umount"
#endif

/* Standard function used by daemon or modules */

int spawnl(char *, ...);
void reset_signals(void);

/* Prototype for module functions */

/* lookup module */

#define AUTOFS_LOOKUP_VERSION 3

#ifdef MODULE_LOOKUP
int lookup_init(char *, int, char **, void **);
int lookup_mount(char *, char *, int, void *);
int lookup_done(void *);
#endif
typedef (*lookup_init_t)(char *, int, char **, void **);
typedef (*lookup_mount_t)(char *, char *, int, void *);
typedef (*lookup_done_t)(void *);
struct lookup_mod {
  lookup_init_t  lookup_init;
  lookup_mount_t lookup_mount;
  lookup_done_t  lookup_done;
  void *dlhandle;
  void *context;
};
struct lookup_mod *open_lookup(char *, char *, char *, int, char **);
int close_lookup(struct lookup_mod *);

/* parse module */

#define AUTOFS_PARSE_VERSION 2

#ifdef MODULE_PARSE
int parse_init(int, char **, void **);
int parse_mount(char *, char *, int, char *, void *);
int parse_done(void *);
#endif
typedef (*parse_init_t)(int, char **, void **);
typedef (*parse_mount_t)(char *, char *, int, char *, void *);
typedef (*parse_done_t)(void *);
struct parse_mod {
  parse_init_t  parse_init;
  parse_mount_t parse_mount;
  parse_done_t  parse_done;
  void *dlhandle;
  void *context;
};
struct parse_mod *open_parse(char *, char *, int, char **);
int close_parse(struct parse_mod *);

/* mount module */

#define AUTOFS_MOUNT_VERSION 3

#ifdef MODULE_MOUNT
int mount_init(void **);
int mount_mount(char *, char *, int, char *, char *, char *, void *);
int mount_done(void *);
#endif
typedef (*mount_init_t)(void **);
typedef (*mount_mount_t)(char *, char *, int, char *, char *, char *, void *);
typedef (*mount_done_t)(void *);
struct mount_mod {
  mount_init_t  mount_init;
  mount_mount_t mount_mount;
  mount_done_t  mount_done;
  void *dlhandle;
  void *context;
};
struct mount_mod *open_mount(char *, char *);
int close_mount(struct mount_mod *);


#endif /* AUTOMOUNT_H */

