/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * LAN packet headers 
 */

#ifndef LAN_HDRS_H
#define LAN_HDRS_H


/* 802.2 frame types (from linux 'if_tr.h' and 'if_ether.h') */
#define ETH_P_802_2	        0x0004
#define ETH_P_TR_802_2	        0x0011


#define MAC_ADDR_LEN               6

#define MAC_TYPE_TR                1           /* token-ring MAC type */
#define MAC_TYPE_PC                2           /* PC Network MAC type */
#define MAC_TYPE_8023              3           /* IEEE 802.3 MAC type */
#define MAC_TYPE_ETH               4           /* ethernet DIX MAC type */


/* Token-ring frame type bit masks */

#define MAX_TR_LPDU_LEN            17936       /* 16 mbps */
#define MAX_TR_FRAME_LEN           17972

#define MIN_TR_PKT_LEN     m        64

#define TR_HDR_LEN                 15          /* not including routing */
#define TR_TRLR_LEN                6           /* FCS + ED + FS */
#define TR_START_DELIMITER         0xAA
#define TR_FRAME_STATUS            0xAA
#define TR_END_DELIMITER           0
#define TR_FRAME_CONTROL           0

#define TR_FC_FRAME_TYPE_MASK      0xC0
#define TR_GET_FRAME_TYPE(fc)      ((((us8) fc) & FC_FRAME_TYPE_MASK) >> 6)
#define TR_FC_FRAME_TYPE_MAC       0x00
#define TR_FC_FRAME_TYPE_LLC       0x40


/* Token ring route length access (2 to 18 bytes in length) */
#define TR_RIF_LENGTH_MASK         0x00F8
#define TR_RIF_SET_ROUTE_LEN(r)    ((((us16)(r)) << 3) & TR_RIF_LENGTH_MASK)
#define TR_RIF_GET_ROUTE_LEN(r)    ((((us16)(r)) & TR_RIF_LENGTH_MASK) >> 3)

#define TR_RIF_SET_BC_IND(r)       (((us16)(r)) & 0x0007)
#define TR_RIF_GET_BC_IND(r)       (((us16)(r)) & 0x0007)

#define TR_RIF_SET_DIR_BIT(r)      ((((us16)(r)) >> 8) & 0x0100)
#define TR_RIF_GET_DIR_BIT(r)      ((((us16)(r)) & 0x0100) >> 8)
#define TR_RIF_COMPL_DIR_BIT(r)    ((~((us16)(r))) & 0x0001)

#define TR_RIF_SET_LARGE_FRAME(r)  ((((us16)(r)) >> 9) & 0x0E00)
#define TR_RIF_GET_LARGE_FRAME(r)  ((((us16)(r)) & 0x0E00) >> 9)

#define TR_MIN_ROUTE_WORDS         1
#define TR_MAX_ROUTE_WORDS         9

#define TR_BC_IND_NON_BC           0       /* non-braodcast */
#define TR_BC_IND_ALL_RT_BC        4       /* all routes broadcast */
#define TR_BC_IND_ONE_RT_BC        6       /* single-route broadcast */

#define TR_LARGEST_FRAME_516       0
#define TR_LARGEST_FRAME_1470      1
#define TR_LARGEST_FRAME_2052      2
#define TR_LARGEST_FRAME_4399      3
#define TR_LARGEST_FRAME_8130      4
#define TR_LARGEST_FRAME_11407     5
#define TR_LARGEST_FRAME_17749     6

/* IEEE 802.3 bit masks */

#define MAX_8023_LPDU_LEN          1500
#define MAX_8023_FRAME_LEN         1526

#define MIN_8023_PKT_LEN           64
#define MAX_8023_PAD_LEN           43

#define IEEE_8023_HDR_LEN           22
#define IEEE_8023_TRLR_LEN          4      /* FCS only (after padding) */

#define IEEE_8023_PREAMBLE_LEN      7
#define IEEE_8023_PREAMBLE_BYTE     0xAA   /* alternating 1s and 0s */
#define IEEE_8023_START_DELIMITER   0xAB   /* 
                                            * alternating 1s and 0s; end with
                                            * 2 consecutive 1s
                                            */


/* Token-ring routing information field (RIF) */
typedef struct
{
   us16            rcf;                /* route control field */
   us16            rseg [8];           /* routing registers */
} token_ring_rif_t;


/* Token-ring MAC structure */
typedef struct
{
   us8             ac;                 /* access control */
   us8             fc;                 /* frame control */
   us8             da [MAC_ADDR_LEN];  /* destination address */
   us8             sa [MAC_ADDR_LEN];  /* source address */
   us16            rcf;                /* route control field */
   us16            rseg [8];           /* routing registers */
} token_ring_mac_hdr_t;


/* 802.3/Ethernet MAC structure */
typedef struct
{
   us8             da [MAC_ADDR_LEN];          /* destination address */
   us8             sa [MAC_ADDR_LEN];          /* source address */
   us16            lpdu_len;                   /* length of "information" */
} ieee_802_3_mac_hdr_t;


#ifdef LAN_HDRS_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LAN_HDRS_C */


EXTRN us16         lan_hdrs_init (frame_t * pdu_frame, us8 mac_type,
                                                       us8 * sa, us8 * da);


#undef EXTRN
#endif /* LAN_HDRS_H */


