/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines SAP component events 
 */

#ifndef LLC_S_EV_H
#define LLC_S_EV_H


/* Types of events (possible values in 'event->type') */
#define SAP_EV_TYPE_SIMPLE             1
#define SAP_EV_TYPE_CONDITION          2
#define SAP_EV_TYPE_PRIM               3
#define SAP_EV_TYPE_PDU                4   /* command/response PDU */
#define SAP_EV_TYPE_ACK_TIMER          5
#define SAP_EV_TYPE_RPT_STATUS         6

#define SAP_EV_ACTIVATION_REQUEST      1
#define SAP_EV_RX_UI                   2
#define SAP_EV_UNITDATA_REQUEST        3
#define SAP_EV_XID_REQUEST             4
#define SAP_EV_RX_XID_C                5
#define SAP_EV_RX_XID_R                6
#define SAP_EV_TEST_REQUEST            7
#define SAP_EV_RX_TEST_C               8
#define SAP_EV_RX_TEST_R               9
#define SAP_EV_DEACTIVATION_REQUEST    10


/* Interfaces for various types of supported events */

typedef struct
{
   us8                     event;
} sap_event_simple_if_t;


typedef struct
{
   us8                     prim;   /* connect, disconnect, reset, ... */
   us8                     type;   /* request, indicate, response, confirm */
   void *                  data;   /* pointer to 'prim_if_block_t' */
} sap_event_prim_if_t;


typedef struct
{                      
   us8                 event;
   us8                 reason;
   frame_t *           frame;
} sap_event_pdu_if_t;


typedef struct
{
   void *                  timer_specific;
} sap_event_timer_if_t;


typedef struct
{
   us8             status;
} sap_event_rpt_sts_if_t;


typedef union
{
   sap_event_simple_if_t   a;          /* 'a' for simple, easy ... */
   sap_event_prim_if_t     prim;
   sap_event_pdu_if_t      pdu;
   sap_event_timer_if_t    tmr;
   sap_event_rpt_sts_if_t  rsts;       /* report status */
} sap_event_if_t;


typedef struct
{
   us8                     type;
   us8                     ind_cfm_flag;
   prim_if_block_t         *prim;
   sap_event_if_t          data;
} sap_state_event_t;


#ifndef LLC_MAIN_C


typedef us16       (*sap_event_t)(void * sap, sap_state_event_t * event);


#ifdef LLC_S_EV_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_S_EV_C */


EXTRN us16     sap_ev_activation_request (void * sap,
                                                 sap_state_event_t * event);
EXTRN us16     sap_ev_rx_ui (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_unitdata_request (void * sap,
                                                 sap_state_event_t * event);
EXTRN us16     sap_ev_xid_request (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_rx_xid_c (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_rx_xid_r (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_test_request (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_rx_test_c (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_rx_test_r (void * sap, sap_state_event_t * event);
EXTRN us16     sap_ev_deactivation_request (void * sap,
                                                 sap_state_event_t * event);


#endif /* LLC_MAIN_C */


#undef EXTRN
#endif /* LLC_S_EV_H */

