/*
 * Copyright 2008 Sony Corporation
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <mars/task.h>
#include <mars_task_test.h>

struct queue_entry {
	uint64_t val1;
	uint64_t val2;
};
static struct queue_entry data;

int mars_task_main(const struct mars_task_args *task_args)
{
	int ret, cont;
	uint64_t host_to_mpu_ea = task_args->type.u64[0];
	uint32_t id = (uint32_t)task_args->type.u64[1];
	uint64_t counter = task_args->type.u64[2];
	uint64_t notify = task_args->type.u64[3];

	mars_test_counter_add(counter, 1);
	mars_test_counter_wait(notify, 1);

	cont = 32767;
	while (cont) {
		ret = mars_task_queue_try_peek(host_to_mpu_ea, &data);

		switch (ret) {
		case MARS_SUCCESS:
			cont --;
			break;
		case MARS_ERROR_BUSY:
			/* empty */
			break;
		default:
			MARS_TEST_ASSERT_ERROR(ret, 0);
			break;
		}
	}

	/* check the peeked data */
	MARS_TEST_ASSERT_EQUAL(data.val1, id);

	return 0;
}
