/*
 * Copyright 2008 Sony Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the names of the copyright holders nor the names of their
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "e_cell.h"
#include "e_cell_err.h"

/*
 *  +----------------+
 *  |                |
 *  V                |
 *  +------------+--------+----------------------
 *  |   unused   |top_addr|  aligned_area
 *  +------------+--------+----------------------
 * top                   ptr
 */

void *aligned_malloc_internal(size_t align, size_t size,
	const char *file, int line)
	{
	void *top, *ptr;

	if (align <= sizeof(void *))
		size += sizeof(void *);
	else
		size += align - 1 + sizeof(void *);

	top = CRYPTO_malloc(size, file, line);
	if (!top)
		return NULL;

	if (align <= sizeof(void *))
		ptr = top + sizeof(void *);
	else
		ptr = (void *)ALIGN_CEIL((uintptr_t)top + sizeof(void *), align);

	DPRINTF("size: %zu, align: 0x%x, top: %p, ptr: %p\n",
		size, align, top, ptr);

	ASSERT(ptr >= top + sizeof(void *));
	ASSERT(ptr <= top + align - 1 + sizeof(void *));

	*(void **)(ptr - sizeof(void *)) = top;
	return ptr;
	}

void aligned_free(void *ptr)
	{
	void *top;

	if (!ptr)
		return;

	top = *(void **)(ptr - sizeof(void *));
	OPENSSL_free(top);
	}
