/*
 *  Copyright 2002 Tobias Ringstrom <tobias@ringstrom.mine.nu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INCLUDE__ipsecadm_h__200204271540
#define INCLUDE__ipsecadm_h__200204271540

#include <stdint.h>
#include <net/if.h>
#include <netinet/ip.h>

#ifndef ARPHRD_IPSEC
#define ARPHRD_IPSEC 31
#endif

#define SIOCIPSEC_GET_TUNNEL   (SIOCDEVPRIVATE + 0)
#define SIOCIPSEC_ADD_TUNNEL   (SIOCDEVPRIVATE + 1)
#define SIOCIPSEC_DEL_TUNNEL   (SIOCDEVPRIVATE + 2)
#define SIOCIPSEC_CHG_TUNNEL   (SIOCDEVPRIVATE + 3)
#define SIOCIPSEC_GET_SA       (SIOCDEVPRIVATE + 4)
#define SIOCIPSEC_ADD_SA       (SIOCDEVPRIVATE + 5)
#define SIOCIPSEC_DEL_SA       (SIOCDEVPRIVATE + 6)
#define SIOCIPSEC_CHG_SA       (SIOCDEVPRIVATE + 7)
#define SIOCIPSEC_GET_STATS    (SIOCDEVPRIVATE + 8)

#define IPSECDEVNAME       "ipsec0"

#define IPSEC_SPI_ANY                 0

#define IPSEC_SA_VERSION              0
#define IPSEC_SA_CRYPTOLEN           32
#define IPSEC_STATS_VERSION           1

struct ipsec_sa_parm
{
	uint32_t    version;

	uint32_t    dst;
	uint32_t    src;
	uint32_t    spi;
	uint32_t    flags;

	char        cipher[IPSEC_SA_CRYPTOLEN];
	int         cipher_keylen;
	const void *cipher_key;
	char        digest[IPSEC_SA_CRYPTOLEN];
	int         digest_keylen;
	const void *digest_key;
	int         digest_hmaclen;
};

struct ipsec_stats
{
	unsigned long	version;

	unsigned long	rx_unknown_sa;
	unsigned long	rx_auth_fail;
	unsigned long	rx_padding_fail;
	unsigned long	rx_non_tunnel;
	unsigned long	rx_no_tunnel;
	unsigned long	rx_mem;
	unsigned long	rx_other;
	unsigned long	rx_ok;

	unsigned long	tx_unknown_sa;
	unsigned long	tx_recursion;
	unsigned long	tx_route;
	unsigned long	tx_mtu;
	unsigned long	tx_mem;
	unsigned long	tx_other;
	unsigned long	tx_ok;
};

struct ipsec_tunnel_parm
{
	char			name[IFNAMSIZ];
	int				link;
	struct iphdr	iph;
	int				spi;
};

extern int verbose;

void usage(void);

const char *ipv4_ntoa(uint32_t addr);

uint32_t ipv4_aton(const char *str);

uint32_t strtospi(const char *str);

int ifname_to_ifindex(const char *name);

char *ifindex_to_ifname(char *ifname, int ifindex);

int ipsec_tunnel_open(const char *name, struct ifreq *ifr, int quiet);

int hex2dec(int c);

int parse_key(const char *str, void *key, int maxsize);

int read_key_file(const char *filename, void *key, int maxsize);

void opt_error(const char *fmt, ...);

#endif
