#ifndef __WL_IOCTL_H__
#define __WL_IOCTL_H__

#ifdef __FreeBSD__
#  include <sys/ioctl.h>
#  include <sys/socket.h>
#  include <net/if.h>
#  include <sys/sockio.h>
#  include <sys/proc.h>
#  define   SIOC_WL_IOCTL               _IOWR('i', 60, struct ifreq)
#else
#  include <linux/if.h>
#  include <linux/sockios.h>
#  define   SIOC_WL_IOCTL               SIOCDEVPRIVATE
#endif

/*
 * WL_IOCTL_BLK is put into ifreq.ifr_data which is a union (16 bytes)
 *
 * Sizeof(WL_IOCTL_BLK) must be less than 16 bteys.
 *
 * Ref: linux/if.h (Linux) and net/if.h (FreeBSD)
 */
typedef struct _WL_IOCTL_BLK {
    unsigned short uCmd;                /* Command to run */
    unsigned short uLen;                /* Length of the data buffer */
    unsigned char  *pData;              /* Pointer to the data buffer */
} WL_IOCTL_BLK, *PWL_IOCTL_BLK;

#define WL_IOCTL_GET_VERSION     0 /* Get driver's version */
#define WL_IOCTL_SET_RESET       1 /* Reset driver (needed after set) */
#define WL_IOCTL_SET_FLASH       2 /* Write current setting into Flash ROM */

#define WL_IOCTL_GET_DBGFLAG    10 /* (Only if with debug enabled) */
#define WL_IOCTL_SET_DBGFLAG    11 /* (Only if with debug enabled) */

#define WL_IOCTL_GET_CHANNEL    12 /* Get channel (1-12)  */
#define WL_IOCTL_SET_CHANNEL    13 /* Set channel (1-12)  */

#define WL_IOCTL_GET_SPEED      14 /* Get speed (1 Mbps / 2 Mbps)  */
#define WL_IOCTL_SET_SPEED      15 /* Set speed (1 Mbps / 2 Mbps)  */

#define WL_IOCTL_GET_MODE       16 /* Get mode (1=AdHoc / 2=infra.)*/
#define WL_IOCTL_SET_MODE       17 /* Set mode (1=AdHoc / 2=infra.)*/

#define WL_IOCTL_GET_ROAMING    18 /* Get roaming (0=off / 1=on) */
#define WL_IOCTL_SET_ROAMING    19 /* Set roaming (0=off / 1=on) */

#define WL_IOCTL_GET_BSSID      20 /* Get BSSID (0<BSSID<FF FF FF FF FF FF */
#define WL_IOCTL_SET_BSSID      21 /* Set BSSID (0<BSSID<FF FF FF FF FF FF */

#define WL_IOCTL_GET_ESSID      22 /* Get ESSID (0<ESSID<999999)   */
#define WL_IOCTL_SET_ESSID      23 /* Set ESSID (0<ESSID<999999)   */

#define WL_IOCTL_GET_SECURITY   24 /* Get SECURITY (0-999999=on / -1=off) */
#define WL_IOCTL_SET_SECURITY   25 /* Set SECURITY (0-999999=on / -1=off) */

#define WL_IOCTL_GET_MONITOR    26 /* Get Monitor Structure */
#define WL_IOCTL_SET_MONITOR    27 /* Set Monitor.MAddr */

#define WL_IOCTL_GET_DOMAIN    28 /* Get freqDomain (0-2)  */
#define WL_IOCTL_SET_DOMAIN    29 /* Set freqDomain  */

/*
 * For not including wlapi.h, because wlu.c does not need it!
 */
struct _WL_Adaptor;

int WL_Ioctl(struct net_device *dev, struct ifreq *rq, int cmd);
int WL_IoctlWla(struct _WL_Adaptor *pAdaptor, WL_IOCTL_BLK *pBlk, void *pDevice);

#endif /* __WL_IOCTL_H__ */
