#ifndef _SHFS_FCACHE_H_
#define _SHFS_FCACHE_H_

#define SHFS_FCACHE_HASH	10
#define SHFS_FCACHE_PAGES	16	/* should be 2^x */
#define SHFS_FCACHE_SIZE	((unsigned)(SHFS_FCACHE_PAGES * PAGE_SIZE))

#include <linux/slab.h>
#include <linux/kdev_t.h>

extern kmem_cache_t	*file_cache;

#define SHFS_FCACHE_READ  0
#define SHFS_FCACHE_WRITE 1

struct shfs_file {
	int		type:2;		/* why gcc complains for 1-bit? */
	int		new:1;
	unsigned	used;
	unsigned	offset;
	unsigned	count;
	char          	*data;
};

struct shfs_sb_info;

int shfs_fcache_add(struct file*);
int shfs_fcache_remove(struct file*, int *);
int shfs_fcache_sync(struct file*);
int shfs_fcache_clear(struct inode *inode);
int shfs_fcache_read(struct file*, unsigned, unsigned, char*);
int shfs_fcache_write(struct file*, unsigned, unsigned, char*);

#endif	/* _SHFS_FCACHE_H_ */
