/*
 *   Copyright (C) International Business Machines Corp., 2000-2003
 *   Portions Copyright (C) Christoph Hellwig, 2001-2002
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#ifndef __JFS_SUPER_H__
#define __JFS_SUPER_H__

#ifdef CONFIG_JFS_POSIX_ACL
# define JFS_ACL_STRING		"ACLs, "
#else
# define JFS_ACL_STRING
#endif

#ifdef CONFIG_JFS_STATISTICS
# define JFS_STATISTICS_STRING	"statistics, "
#else
# define JFS_STATISTICS_STRING
#endif

#ifdef CONFIG_JFS_DEBUG
# define JFS_DBG_STRING		"debug"
#else
# define JFS_DBG_STRING		"no debug"
#endif

#define JFS_BUILD_OPTIONS	JFS_ACL_STRING \
				JFS_STATISTICS_STRING \
				JFS_DBG_STRING /* DBG must be last */

#endif	/* __JFS_SUPER_H__ */
