#ifndef _LINUX_HDAPS_H
#define _LINUX_HDAPS_H

#include <linux/types.h>

struct hdaps_data {
	__u16 x_pos;		/* x position value */
	__u16 y_pos;		/* y position value */
	__u16 x_variation;	/* this might hold something else */
	__u16 y_variation;	/* this might hold something else */
	__u8 state;		/* accelerometer state */
	__u8 temp;		/* accelerometer temp (in celcius) */
	__u8 temp2;		/* really the temperature again? */
	__u8 unknown;		/* we don't know what this holds */
	__u8 km_activity;	/* any keyboard/mouse activity */
};

#define KEYBD_BIT	0x20
#define MOUSE_BIT	0x40

#define KEYBD_ISSET(n)	(!! (n & KEYBD_BIT))
#define MOUSE_ISSET(n)	(!! (n & MOUSE_BIT))

#endif	/* _LINUX_HDAPS_H */
