/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rpcsvc/nis.h>
#include "db_private.h"

#define E_VAL eobj->object->en_cols.en_cols_val[i].ec_value.ec_value_val
#define E_LEN eobj->object->en_cols.en_cols_val[i].ec_value.ec_value_len

/* Create a table with hash values for the searchable entries of
   the entry object. */

db_status
calc_entry_hash (table_t *tobj, entry_t *eobj)
{
  u_int i;

  eobj->hashes_len = tobj->object->ta_cols.ta_cols_len;
  eobj->hashes = malloc (sizeof (uint32_t) * eobj->hashes_len);
  for (i = 0; i < tobj->object->ta_cols.ta_cols_len; ++i)
    if (tobj->object->ta_cols.ta_cols_val[i].tc_flags & TA_SEARCHABLE)
      eobj->hashes[i] = __nis_hash (E_VAL, E_LEN);
    else
      eobj->hashes[i] = 0;

  return DB_SUCCESS;
}
