/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nis_db.h"
#include "db_private.h"

db_result *
db_reset_next_entry (const char *table_name,
		     const db_next_desc *next_handle)
{
  db_result *res;
  struct timeval t_start, t_end;

  gettimeofday (&t_start, NULL);

  if ((res = calloc (1, sizeof (db_result))) == NULL)
    return NULL;

  res->status = DB_SUCCESS;
  if (table_name == NULL || strlen (table_name) == 0)
    {
      res->status = DB_BADTABLE;
      goto bailout;
    }

  if (next_handle == NULL)
    {
      res->status = DB_BADQUERY;
      goto bailout;
    }

  /* XXX There is nothing to do for us in the moment */

 bailout:
  gettimeofday(&t_end, NULL);
  res->ticks += (t_end.tv_usec - t_start.tv_usec) +
    ((t_end.tv_sec - t_start.tv_sec) * 1000000);

  return res;
}
