/* Copyright (C) 2004 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define _GNU_SOURCE

#include <stdio.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdlib.h>
#include "logging.h"

static char *msg_table[] = {
  /*  0 */ "NULL",
  /*  1 */ "path specification denied - by=%u",
  "permission denied - name=%s, id=%u, by=%u",
  "password aging information displayed - user=%s, uid=%u, by=%u",
  "group is unknown - group=%s, by=%u",
  "user changing the password for group - group=%s, by=%u",
  "password change aborted - for=%s, by=%u",
  "password modification exceeded max tries, aborted - group=%s, by=%u",
  "failed to change group password - group=%s, by=%u",
  "group password removed - group=%s, gid=%u, by=%u",
  /* 10 */ "group password changed - group=%s, gid=%u, by=%u",
  "can't get unique gid in range %u - %u",
  "GID %u is not unique - by=%u",
  "invalid name - group=%s, by=%u",
  "cannot lock group file: already locked",
  "group already exists - group=%s, by=%u",
  "failed to add new group - group=%s, gid=%u, by=%u",
  "new group added - group=%s, gid=%u, by=%u",
  "GID `%u' is primary group of `%s' - by=%u",
  "cannot remove user's primary group - group=%s, by=%u",
  /* 20 */ "failed to delete group - group=%s, gid=%u, by=%u",
  "group deleted - group=%s, gid=%u, by=%u",
  "cannot lock password file: already locked",
  "failed to modify group - group=%s, gid=%u, by=%u",
  "account removed from group - account=%s, group=%s, gid=%u, by=%u",
  "account added to group - account=%s, group=%s, gid=%u, by=%u",
  "group name changed  - group=%s, oldgroup=%s, gid=%u, by=%u",
  "group gid changed - group=%s, gid=%u, oldgid=%u, by=%u",
  "password status display for all users denied - by=%u",
  "password status displayed for all users - by=%u",
  /* 30 */ "user is unknown - user=%s, by=%u",
  "password change denied - user=%s, uid=%u, by=%u",
  "password status displayed - user=%s, uid=%u, by=%u",
  "password change failed, pam error %d - user=%s, uid=%u, by=%u",
  "password changed - user=%s, uid=%u, by=%u",
  "cannot determine user name - uid=%u",
  "defaults changed - gid=%u, home=%s, shell=%s, inactive=%li, expire=%s, by=%u",
  "updating default config file `%s' faild - by=%u",
  "UID %u is not unique - by=%u",
  "invalid name - account=%s, by=%u",
  "account already exists - account=%s, by=%u",
  "new account added - account=%s, uid=%u, gid=%u, home=%s, shell=%s, by=%u",
  "home directory created - account=%s, uid=%u, home=%s, by=%u",
  "running %s command - script=%s, account=%s, uid=%u, gid=%u, home=%s, by=%u",
  "error removing account from group - account=%s, uid=%u, group=%s, gid=%u, by=%u",
  "`%s' is not owned by user, not removed - account=%s, uid=%u, by %u",
  "home directory deleted - account=%s, uid=%u, home=%s, by=%u",
  "failed to delete account - account=%s, uid=%u, by=%u",
  "account deleted - account=%s, uid=%u, by=%u"};

void (*sec_log_fnc) (const char *program, unsigned int id, ...) = NULL;

static void
sec_log_internal (const char *program __attribute__((unused)),
		  unsigned int id, ...)
{
  va_list ap;

  if (id > sizeof (msg_table) / sizeof (char *))
    abort ();

  va_start (ap, id);
  if (msg_table[id] != NULL)
    {
#if 0
      char *buf;
      if (asprintf (&buf, "%s: %s", program, msg_table[id]) > 0)
	{
	  vsyslog (LOG_INFO, buf, ap);
	  free (buf);
	}
      else
	{ /* Run out of memory ... */
	  char buf2[1024];
	  snprintf (buf2, sizeof (buf2), "%s: %s", program, msg_table[id]);
	  vsyslog (LOG_INFO, buf2, ap);
	}
#else
      vsyslog (LOG_INFO, msg_table[id], ap);
#endif
    }
  va_end (ap);
}

void
open_sec_log (void)
{
  sec_log_fnc = sec_log_internal;
}
