/* Copyright (C) 2004 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define _GNU_SOURCE

#include <dlfcn.h>
#include <stdio.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdlib.h>
#include <locale.h>
#include <libintl.h>

#include "logging.h"

#ifndef _
#define _(String) gettext (String)
#endif

void (*sec_log_fnc) (const char *program, unsigned int id, ...) = NULL;
static void (*open_sec_log_fnc) (const char *arguments) = NULL;

void
open_sec_log (const char *program)
{
  void *handle = NULL;
  char *err_msg;

  openlog (program, LOG_PID, LOG_AUTHPRIV);

  handle = dlopen (PLUGINDIR"/liblog_syslog.so.1", RTLD_NOW);
  if (!handle)
    {
      err_msg = dlerror ();
      syslog (LOG_ERR, err_msg);
      fprintf (stderr, _("Cannot open logging plugin:\n%s\n"),
	       err_msg);
      return;
    }

  sec_log_fnc = dlsym (handle, "syslog_sec_log");
  if ((err_msg = dlerror ()) != NULL)
    {
      syslog (LOG_ERR, err_msg);
      fprintf (stderr, _("Cannot find symbol \"syslog_sec_log\":\n%s\n"),
	       err_msg);
      dlclose (handle);
      return;
    }

  open_sec_log_fnc = dlsym (handle, "syslog_open_sec_log");
  if ((err_msg = dlerror ()) != NULL)
    {
      syslog (LOG_ERR, err_msg);
      fprintf (stderr, _("Cannot find symbol \"open_syslog_sec_log\":\n%s\n"),
	       err_msg);
      dlclose (handle);
      return;
    }

  (*open_sec_log_fnc)(NULL);

  return;
}
