#ifndef ZZZ_INFO_H
#define ZZZ_INFO_H


enum crw_types { crw_short, crw_long, crw_string, crw_type_last };

struct crw_property {
   off_t offset;
   off_t len;
   long int value;
   char *string_value;
   enum crw_types type;
};

enum crw_items {
   timestamp,
   fileformat,
   owner,
   vendor,
   camera_model,
   camera_firmware,
   camera_serial,
   shutter_speed,
   bulb_duration,
   aperature,
   iso,
   creative_modes,
   autofocus_mode,
   auto_manual_focus1,
   auto_manual_focus2,
   metering_mode,
   photo_in_sequence,    // number of the photo in continuous drive
   shutter_delay,
   driver_mode,
   white_point,
   exposure_compensation,
   focus_distance_lower,
   focus_distance_upper,
   zoom_range_lower,
   zoom_range_upper,
   focal_length_used,
   flash_compensation,
   parameter_contrast,
   parameter_saturation,
   parameter_sharpness,
   parameter_colortone,
   flash_mode,
   orientation,
   rotation,
   aeb_in_sequence,
   aeb_bracket_value,
   cf_2, cf_3, cf_4, cf_5, cf_6, cf_7, cf_8, cf_9, cf_10, cf_11, cf_12, cf_13, 
   cf_14, cf_15,
   x_gamma,  /* very unsure about this designation */
   x_whitepoint, 
   x_lensid,
   x_colortemp,
   crw_items_last
};


enum crw_shutter_speed {
   s_4000 = 0x0180, s_3200 = 0x0174, s_3000 = 0x0170, s_2500 = 0x016c,
   s_2000 = 0x0160, s_1600 = 0x0154, s_1500 = 0x0150, s_1250 = 0x014c,
   s_1000 = 0x0140, s_800  = 0x0134, s_750  = 0x0130, s_640  = 0x012c,
   s_500  = 0x0120, s_400  = 0x0114, s_350  = 0x0110, s_320  = 0x010c,
   s_250  = 0x0100, s_200  = 0x00f4, s_180  = 0x00f0, s_160  = 0x00ec,
   s_125  = 0x00e0, s_100  = 0x00d4, s_90   = 0x00d0, s_80   = 0x00cc,
   s_60_1 = 0x00c4,
   s_60_2 = 0x00c0, s_50   = 0x00b4, s_45   = 0x00b0, s_40   = 0x00ac,
   s_30   = 0x00a0, s_25   = 0x0094, s_20_1 = 0x0090, s_20_2 = 0x008c,
   s_15   = 0x0080, s_13   = 0x0074, s_10_1 = 0x0070, s_10_2 = 0x006c, 
   s_8    = 0x0060, s_6_1  = 0x0054, s_6_2  = 0x0050, s_5    = 0x004c, 
   s_4    = 0x0040,
   s0_3_1 = 0x0034, s0_3_2 = 0x0030, s0_4   = 0x002c, s0_5   = 0x0020, 
   s0_6   = 0x0014, s0_7   = 0x0010, s0_8   = 0x000c, s1_0_1 = 0x0000, 
   s1_0_2 = 0xfffc, s1_3   = 0xfff4, s1_5   = 0xfff0, s1_6   = 0xffec, 
   s2     = 0xffe0, s2_5   = 0xffd4, s3     = 0xffd0, s3_2   = 0xffcc, 
   s4     = 0xffc0, s5     = 0xffb4, s6_1   = 0xffb0, s6_2   = 0xffac,
   s8     = 0xffa0, s10_1  = 0xff94, s10_2  = 0xff90, s13    = 0xff8c,
   s15    = 0xff80, s20_1  = 0xff74, s20_2  = 0xff70, s25    = 0xff6c, 
   s30    = 0xff60,
   sbulb  = 0xff30,
   slast
};

enum crw_fstops {
   fnone = 0x8000,
   f1_0 = 0x0000, /* ?? */
   f1_1 = 0x000c, /* ?? */
   f1_2 = 0x0014, /* ?? */
   f1_4 = 0x0020, /* ?? */
   f1_6 = 0x002c, /* ?? */ 
   f1_8 = 0x0038, 
   f2_0 = 0x0040, f2_2 = 0x004c, f2_5 = 0x0054,
   f2_8 = 0x0060, f3_2 = 0x006c, f3_5_1 = 0x0074, f3_5_2 = 0x070,
   f4_0 = 0x0080, f4_5_1 = 0x008c, f4_5_2 = 0x0090, f5_0 = 0x0094, 
   f5_6 = 0x00a0, f6_3 = 0x00ac, 
   f6_7 = 0x00b0, f7_1 = 0x00b4, 
   f8_0 = 0x00c0, f9_0 = 0x00cc,
   f9_5 = 0x00d0, f10  = 0x00d4, 
   f11  = 0x00e0, f13_1  = 0x00ec, f13_2 = 0x00f0, f14  = 0x00f4, 
   f16  = 0x0100, f18  = 0x010c, 
   f19  = 0x0110, f20  = 0x0114, 
   f22  = 0x0120, f25  = 0x012c, f27  = 0x0130,
   f29  = 0x0134,                f32  = 0x0140,
                  f36  = 0x014c, 
   f38  = 0x0150,                f40  = 0x0154,
   f45  = 0x0160, /* ?? */
   f51  = 0x016c, /* ?? */
   f54  = 0x0170, /* ?? */
   f57  = 0x0174, /* ?? */
   f64  = 0x0180, /* ?? */
   f72  = 0x018c, /* ?? */
   f76  = 0x0190, /* ?? */
   f81  = 0x0194, /* ?? */
   f91  = 0x01a0, /* ?? */
   flast
};

enum crw_iso { iso100 = 0x00a0, iso200 = 0x00c0, iso400 = 0x00e0, 
               iso800 = 0x0100, iso1000 =0x010c };

enum crw_compensations {
   ev_2_0 = 0xffc0,           ev_1_6 = 0xffcc, 
   ev_1_5 = 0xffd0, /* ?? */  ev_1_3 = 0xffd4,
   ev_1_0 = 0xffe0,           ev_0_6 = 0xffec,
   ev_0_5 = 0xfff0, /* ?? */  ev_0_3 = 0xfff4,
   ev0    = 0x0000,           ev0_3  = 0x000c,
   ev0_5  = 0x0010, /* ?? */  ev0_6  = 0x0014,
   ev1_0  = 0x0020,           ev1_3  = 0x002c,
   ev1_5  = 0x0030, /* ?? */  ev1_6  = 0x0034,
   ev2_0  = 0x0040, 
   evlast 
};

enum crw_creativ_modes {
   cm_adep = 0x0005, cm_m    = 0x0004,
   cm_av   = 0x0003, cm_tv   = 0x0002,
   cm_p    = 0x0001, cm_none = 0x0000,
   cm_last
};

enum crw_autofocus_modes {
   af_single = 0x0000, af_servo = 0x0001, af_mf = 0x0003, af_last
};

enum crw_metering_modes {
   mm_spot = 0x0005, mm_center = 0x0004, mm_multi = 0x0003, mm_last
};

enum crw_photo_series {
   ps_single = 0x0000, ps_series = 0x0001, ps_last
};

enum crw_whitepoint_mode {
   wp_auto        = 0x0000, wp_sun         = 0x0001, wp_cloud       = 0x0002,
   wp_tungsten    = 0x0003, wp_fluorescent = 0x0004, wp_flash       = 0x0005,
   wp_manual      = 0x0006,
   wp_last
};

enum crw_parameter_values {
   pv1 = 0x0001, pv0 = 0x0000, pv_1 = 0xffff, pv_last
};

enum crw_flash_modes {
   fm_none = 0x0000, fm_normal = 0x0002, fm_redeye = 0x0006, fm_last
};

enum crw_orientation {
   o_landscape = 0x0000, o_portrait = 0x001c, o_last
};

enum crw_rotation {
   r_0 = 0x0c00, r_90 = 0x005a, r_270 = 0x010e, r_last
};

#endif /* ZZZ_INFO_H */
