/* Header for scoring alogrithm */

#ifndef SCORE_H
#define SCORE_H

int BAD_BISHOP =          2;
int DOUBLED_PAWN =        3;
int WEAK_PAWN =           8;
int BACKWARD_PAWN =       4;
int PAWN_ISLAND =        10;
int PASSED_PAWN =        11;
//int PAWN_SHIELD =         5;
int BISHOP_PAIR =        40;
int ROOK_CONN_OPEN =     10;
int ROOK_CONN_HALF_OPEN = 7;
int CON_PASSED_PAWNS =  200;
int FILE_BONUS =         10;
int HALF_FILE_BONUS =     5;
int CASTLED =            10;
int NO_POSSIBLE_CASTLE = 20;
int ROOK_KING_FILE =      3;
int TRADE_PIECES =        2;
int KEEP_PAWNS =          2;
int OPPOSITION =         12;
int BISH_PAWN_BLOCK =     7;
int PAWN_DUO =            2;
int BOXED_IN_ROOK =      40;
int KNIGHT_OUTPOST =      2;
int BISHOP_OUTPOST =      1;

int KING_SIDE_DEFECTS =   4;
int QUEEN_SIDE_DEFECTS =  4;
int MISSING_A_PAWN =      8;
int MISSING_B_PAWN =     10;
int MISSING_C_PAWN =     10;
int MISSING_F_PAWN =     12;
int MISSING_G_PAWN =     10;
int MISSING_H_PAWN =     10;

int ROOK_OPEN_FILE =     10;
int ROOK_HALF_OPEN_FILE = 5;

int KING_ATTACKS =       15;
int EARLY_EXIT =        150;

// Outpost squares and bitmasks for setting which outposts 
// are filled
int white_outpost[8] = { 34,35,36,37,42,43,44,45 };
int outpost_score[8] = {  4, 5, 5, 4, 3, 6, 6, 3 };
int black_outpost[8] = { 26,27,28,29,18,19,20,21 };
unsigned char bitmask[8] = { 1,2,4,8,16,32,64,128 };


// values for having pieces near the king, changes with stage
char king_proximity[4][7][8] = {
{ { 0, 0, 0, 0, 0, 0, 0, 0 },
  { 0,15,11, 6, 3, 0, 0, 0 },
  { 0, 5, 9, 9, 5, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0,15,12, 7, 5, 3, 0, 0 },
  { 0, 0, 0, 0, 0, 0, 0, 0 } },

{ { 0, 0, 0, 0, 0, 0, 0, 0 },
  { 0,15,11, 6, 3, 0, 0, 0 },
  { 0, 5, 9, 9, 5, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0,15,12, 7, 5, 3, 0, 0 },
  { 0, 0, 0, 0, 0, 0, 0, 0 } },

{ { 0, 0, 0, 0, 0, 0, 0, 0 },
  { 0, 0, 0, 0, 0, 0, 0, 0 },
  { 0, 5, 9, 9, 5, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0,15,12, 7, 5, 3, 0, 0 },
  { 0, 0, 0, 0, 0, 0, 0, 0 } },

{ { 0, 0, 0, 0, 0, 0, 0, 0 },
  { 0,-5,-3, 0, 2, 4, 7, 9 },
  { 0, 5, 9, 9, 5, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0, 7, 5, 3, 3, 0, 0, 0 },
  { 0,15,12, 7, 5, 3, 0, 0 },
  { 0, 0, 0, 0, 0, 0, 0, 0 } } };

// Value of the pieces
int value[7] = { 0, 100, 330, 330, 550, 1000, 10000 };

// Piece square tables
int piece_sq[2][7][64];

// proto-types for piece square tables, first index is for the stage of
// the game, 2nd index is for piece
// stage 0 = opening
// stage 1 = early middle-game
// stage 2 = late middle-game
// stage 3 = ending

int proto_piece_sq[4][7][64] = {

// Reading these is a little tricky.  These tables
// are set up to look like a chess board from white's
// point of view, but they are indexed from black's
// point of view.  The whitef array is used to
// map these values to the right squares for white.

/*----------------------  Opening ------------------------*/
// For no piece ...
{ {
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For the pawn
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0, 25, 25,-15,-15,-15,
        0,  0,  0, 10, 10,-10,-10,-10,
        0,  0,  0,-10,-10,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For knight proto_piece_sq[KNIGHT]
{
       -8, -6, -4, -4, -4, -4, -6, -8,
       -6,  0,  0,  0,  0,  0,  0, -6,
       -4,  7,  8,  8,  8,  8,  7, -4,
       -4,  7,  7,  8,  8,  7,  7, -4,
       -4,  6,  7,  8,  8,  7,  6, -4,
       -4,  5,  8,  6,  6,  8,  5, -4,
       -6,  0,  0,  5,  5,  0,  0, -6,
       -8,-10, -4, -4, -4, -4,-10, -8
},

// For bishop proto_piece_sq[BISHOP] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  7,  8,  8,  7,  0,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  5,  0,  0,  0,  0,  5,  0,
        0,  0, -7,  0,  0, -7,  0,  0
},

// For rook proto_piece_sq[ROOK] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  5,  5,  0,  0,  0
},

// For queen proto_piece_sq[QUEEN] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  3,  3,  3,  0,  0,  0,
        0,  0,  0,  3,  0,  0,  0,  0
},

// For king proto_piece_sq[KING] =
{
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
       -5, -5,-25,-25,-25,-25, -5, -5,
       10, 10, 10,-15,  0,-15, 10, 10
} },

/*---------------------- Early Middle Game ------------------------*/
// For no piece ...
{ {
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For the pawn
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0, 25, 25,  0,  0,  0,
        0,  0,  0, 25, 25,-15,-15,-15,
        0,  0,  0, 10, 10,-15, -5, -5,
        0,  0,  0,-10,-10,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For knight proto_piece_sq[KNIGHT] =
{
      -10, -7, -5, -5, -5, -5, -5,-10,
       -7,  2,  4,  4,  4,  4,  2, -7,
       -5,  7,  8,  8,  8,  8,  7, -5,
       -5,  7,  7,  8,  8,  7,  7, -5,
       -5,  6,  7,  8,  8,  7,  6, -5,
       -5,  3,  8,  6,  6,  8,  3, -5,
       -7,  0,  3,  5,  5,  3,  0, -7,
      -10,-10, -5, -5, -5, -5,-10,-10
},

// For bishop proto_piece_sq[BISHOP] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  7,  8,  8,  7,  0,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  5,  0,  0,  0,  0,  5,  0,
        0,  0, -7,  0,  0, -7,  0,  0
},

// For rook proto_piece_sq[ROOK] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
       10, 10, 10, 10, 10, 10, 10, 10,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  5,  5,  0,  0,  0
},

// For queen proto_piece_sq[QUEEN] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  3,  3,  3,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For king proto_piece_sq[KING] =
{
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
      -25,-25,-25,-25,-25,-25,-25,-25,
       -5, -5,-25,-25,-25,-25, -5, -5,
       10, 10, 10,-15,  0,-15, 10, 10
} },

/*---------------------- Late Middle Game ------------------------*/
// For no piece ...
{ {
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For the pawn
{
        0,  0,  0,  0,  0,  0,  0,  0,
       50, 50, 50, 50, 50, 50, 50, 50,
       20, 20, 20, 25, 25, 20, 20, 25,
       10, 10, 10, 15, 15, 10, 10, 15,
        5,  5,  5, 15, 15,  5,  5, 10,
        3,  3,  3,  5,  5,  3,  3,  5,
        0,  0,  0, -5, -5,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For knight proto_piece_sq[KNIGHT] =
{
      -10, -7, -5, -5, -5, -5, -5,-10,
       -7,  2,  4,  4,  4,  4,  2, -7,
       -5,  7,  8,  8,  8,  8,  7, -5,
       -5,  7,  7,  8,  8,  7,  7, -5,
       -5,  6,  7,  8,  8,  7,  6, -5,
       -5,  3,  8,  6,  6,  8,  3, -5,
       -7,  0,  3,  5,  5,  3,  0, -7,
      -10,-10, -5, -5, -5, -5,-10,-10
},

// For bishop proto_piece_sq[BISHOP] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  7,  8,  8,  7,  0,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  0,  0,  7,  7,  0,  0,  0,
        0,  5,  0,  0,  0,  0,  5,  0,
        0,  0, -5,  0,  0, -5,  0,  0
},

// For rook proto_piece_sq[ROOK] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
       10, 10, 10, 10, 10, 10, 10, 10,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For queen proto_piece_sq[QUEEN] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
       10, 10, 10, 10, 10, 10, 10, 10,
        0,  5,  7,  7,  7,  7,  5,  0,
        0,  5,  7,  8,  8,  7,  5,  0,
        0,  5,  7,  8,  8,  7,  5,  0,
        0,  3,  5,  5,  5,  5,  3,  0,
        0,  0,  3,  3,  3,  3,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For king proto_piece_sq[KING] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
} },

/*---------------------- End Game ------------------------*/
// For no piece ...
{ {
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For the pawn
{
        0,  0,  0,  0,  0,  0,  0,  0,
      100,100,100,100,100,100,100,100,
       55, 55, 55, 55, 55, 55, 55, 55,
       25, 25, 25, 25, 25, 25, 25, 25,
       15, 15, 15, 15, 15, 15, 15, 15,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For knight proto_piece_sq[KNIGHT] =
{
      -10, -7, -5, -5, -5, -5, -5,-10,
       -7,  2,  4,  4,  4,  4,  2, -7,
       -5,  7,  8,  8,  8,  8,  7, -5,
       -5,  7,  7,  8,  8,  7,  7, -5,
       -5,  6,  7,  8,  8,  7,  6, -5,
       -5,  3,  8,  6,  6,  8,  3, -5,
       -7,  0,  3,  5,  5,  3,  0, -7,
      -10, -7, -5, -5, -5, -5, -7,-10
},

// For bishop proto_piece_sq[BISHOP] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  5,  5,  7,  7,  5,  5,  0,
        0,  5,  7,  7,  7,  7,  5,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  7,  7,  8,  8,  7,  7,  0,
        0,  5,  7,  7,  7,  7,  5,  0,
        0,  5,  5,  7,  7,  5,  5,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For rook proto_piece_sq[ROOK] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        5,  5,  5,  5,  5,  5,  5,  5,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For queen proto_piece_sq[QUEEN] =
{
        0,  0,  0,  0,  0,  0,  0,  0,
        0,  5,  5,  5,  5,  5,  5,  0,
        0,  5,  7,  7,  7,  7,  5,  0,
        0,  5,  7,  8,  8,  7,  5,  0,
        0,  5,  7,  8,  8,  7,  5,  0,
        0,  3,  5,  5,  5,  5,  3,  0,
        0,  0,  3,  3,  3,  3,  0,  0,
        0,  0,  0,  0,  0,  0,  0,  0
},

// For king proto_piece_sq[KING] =
{
      -25,-15,-10, -5, -5,-10,-15,-25,
      -15,  3,  5,  5,  5,  5,  3,-15,
      -10,  5,  7,  7,  7,  7,  5,-10,
       -5,  5,  7,  7,  7,  7,  5, -5,
       -5,  5,  7,  7,  7,  7,  5, -5,
      -10,  5,  7,  7,  7,  7,  5,-10,
      -15,  3,  5,  5,  5,  5,  3,-15,
      -25,-15,-10, -5, -5,-10,-15,-25
} } };

// white reference array to access piece-sq tables
// black can access the arrays directly
int whitef[64] = {
       56, 57, 58, 59, 60, 61, 62, 63,
       48, 49, 50, 51, 52, 53, 54, 55,
       40, 41, 42, 43, 44, 45, 46, 47,
       32, 33, 34, 35, 36, 37, 38, 39,
       24, 25, 26, 27, 28, 29, 30, 31,
       16, 17, 18, 19, 20, 21, 22, 23,
        8,  9, 10, 11, 12, 13, 14, 15,
        0,  1,  2,  3,  4,  5,  6,  7
};

#endif /* SCORE_H */

