// search.h header file for search.cpp

#ifndef SEARCH_H
#define SEARCH_H

#define UNIT_DEPTH 64
#define DEPTH(x)  (x>>6)

/* extensions */
// These values can be modified by the search.par text file.
// The code to read the search.par file is in score.cpp.
int CHECK_EXT =   48;
int ONE_REPLY_TO_CHECK = 48;
int PAWN_EXT =    48;
int RE_CAPT_EXT = 48;
int MATE_EXT =    48;
int INIT_EXT =    48;

// Null move reduction factor
int R = 128;

// Razoring depth
int RAZOR_DEPTH = 192;

position sp[MAXD];                  // array of search positions

move_list slist[MAXD+1];            // array of search lists
move pc[MAXD+1][MAXD+1];            // triangular array for search
                                    // principle continuation

int max_ply;                        // max ply of current search
int start_time;                     // start time of current search
int limit;                          // time limit of search
int max_limit;                      // maximum time of search
int ponder = 0;                     // flag for pondering
int last_ponder = 0;                // flag for did we ponder last move?
int ponder_time = 0;                // record of time used on last pondering
int ponder_time_double = 0;         // time doublings required (pondering)
int wbest, wply;                    // whisper variables for search summary
int learned;                        // has book learning already happened?
int turn;                           // Current game turn
int root_alpha, root_beta;          // values at the root of search 
int root_tb_score, root_wtm;
int EGTB = 0;                       // maximum tablebase pieces
int max_depth, start_depth;         // depths of search (starting, ending)  
int last_depth = 1;                 // depth of previous search
int delta_score;                    // futility score in qsearch
int fail = 0;                       // fail high(+1)/low(-1) flag  
int book_search = 0;                // flag for searching a book move    
int g_last;                         // last returned score of search 

int killer1[2], killer2[2], killer3[2]; // killer moves

move nomove;                        // move for initization purposes   
move hmove;                         // move from hash table
move bookm;                         // move from opening book
move ponder_move;                   // move we are pondering

unsigned int history[64][64];      // table for history scores

// These are a collection of counters that keep track of search
// statistics and timing checks.
unsigned int node_count, eval_count, time_count, extensions;
unsigned int phash_count, hash_count, hmove_count, q_count;
unsigned int null_cutoff, internal_iter, egtb_probes, egtb_hits;
// define how many nodes between time checks.
unsigned int time_check_interval = 12500;

// hash codes for side to move, piece types, stage of game, castling status,
//   and en passant rights
extern h_code wtm, btm, hval[13][64], stage_code[4];
extern h_code castle_code[16], ep_code[64];

extern h_code p_list[600];     // list of position hash codes in game so far

// counter to tell the hash table how old the entries are
extern int h_id;

int stage;                         // stage of the game

extern int xboard, post;           // xboard flag, posting flag
extern int book, ALLEG, ics;       // flags from main.cpp to control the book
                                   // and playing modes
extern int learn_count, learn_bk;  // flag to control learning and keep track
                                   // of how many book moves have been played
extern int tsuite, analysis_mode;  // flags to determine whether we are in
                                   // analysis mode or a test suite
extern float timeleft;             // total time left in the game
extern int best_depth;             // best depth reached (for testsuites) 
extern int no_book;                // counter for positions with no book moves
extern ofstream logfile;           // logfile
extern int logging;                // flag for logging  
int BOOK_LEARNING = 1;          // flag for book learning

#if DEBUG
 ofstream outfile;
#endif

#endif  /* SEARCH_H */









