#             InspIRCd Main Makefile
#
#     (C) InspIRCd Development Team, 2002-2007
# This file is automagically generated by configure, from
#    .Makefile.inc. Any changes made will go away! :P
# Please do not edit unless you know what you're doing.
#

CC = @CC@
MAKE = @MAKEPROG@
PROGS = inspircd
FLAGS = @FLAGS@
DEBUG = @DEVELOPER@
LDLIBS = @LDLIBS@
BASE = $(DESTDIR)@BASE_DIR@
CONPATH = $(DESTDIR)@CONFIG_DIR@
MODPATH = $(DESTDIR)@MODULE_DIR@
BINPATH = $(DESTDIR)@BINARY_DIR@
LAUNCHDPATH = $(DESTDIR)/System/Library/LaunchDaemons
LIBPATH = $(DESTDIR)@LIBRARY_DIR@
LIB_EXT = @LIBRARY_EXT@
MODULES = @MODULES@
STATICLIBS = @STATICLIBS@
INSTMODE = 0755
MAKEARGS = 'PROGS=${PROGS}' 'FLAGS=${FLAGS}' 'CC=${CC}' 'LDLIBS=${LDLIBS}' 'MODULES=${MODULES}' 'MODPATH=${MODPATH}' 'LIBPATH=${LIBPATH}' 'STATICLIBS=${STATICLIBS}' 'INSTMODE=${INSTMODE}'

all: @MAKEORDER@ finishmessage

debug:
	@echo ""
	@echo "*************************************"
	@echo "*    BUILDING WITH DEBUG SYMBOLS    *"
	@echo "*                                   *"
	@echo "*  Please be aware that this build  *"
	@echo "*  will consume a very large amount *"
	@echo "*   of disk space (350mb+) and may  *"
	@echo "*  run noticably slower. Only build *"
	@echo "*   InspIRCd with debug symbols if  *"
	@echo "* you are developing modules or are *"
	@echo "*      experiencing problems.       *"
	@echo "*                                   *"
	@echo "*************************************"
	${MAKE} -C . 'FLAGS=${DEBUG}' all

mods:
	@echo "Making modules..."
	${MAKE} -C src/modules DIRNAME="src/modules" $(MAKEARGS)

# Make this depend on 'ircd' and 'mods', so its always output last even with -j
finishmessage: ircd mods
	@echo ""
	@echo "*************************************"
	@echo "*        BUILD COMPLETE!            *"
	@echo "*                                   *"
	@echo "*   To install InspIRCd, type:      *"
	@echo "*         make install              *"
	@echo "*************************************"

ircd:
	@echo "*************************************"
	@echo "*       BUILDING INSPIRCD           *"
	@echo "*                                   *"
	@echo "*   This will take a *long* time.   *"
	@echo "*     Why not read our wiki at      *"
	@echo "*   http://www.inspircd.org/wiki    *"
	@echo "*  while you wait for make to run?  *"
	@echo "*************************************"
	${MAKE} -C src DIRNAME="src" $(MAKEARGS)

install: all@EXTRA_DIR@
	@-install -d -m $(INSTMODE) ${BASE}
	@-install -d -m $(INSTMODE) $(LIBPATH)
	@-install -d -m $(INSTMODE) $(BINPATH)
	@-install -d -m $(INSTMODE) $(CONPATH)
	@-install -d -m $(INSTMODE) ${MODPATH}
	-install -m $(INSTMODE) src/inspircd $(BINPATH)
	-install -m $(INSTMODE) @STARTSCRIPT@ $(@DESTINATION@) 2>/dev/null
	-install -m $(INSTMODE) src/cmd_admin.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_away.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_clearcache.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_commands.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_connect.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_die.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_eline.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_gline.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_info.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_invite.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_ison.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_join.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_kick.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_kill.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_kline.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_links.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_list.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_loadmodule.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_lusers.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_map.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_modules.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_motd.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_names.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_nick.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_notice.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_oper.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_part.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_pass.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_ping.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_pong.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_privmsg.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_qline.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_quit.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_rehash.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_reloadmodule.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_restart.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_rules.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_server.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_squit.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_stats.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_summon.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_time.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_topic.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_trace.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_unloadmodule.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_user.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_userhost.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_users.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_version.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_wallops.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_who.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_whois.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_whowas.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_zline.so $(LIBPATH)
	-install -m $(INSTMODE) src/cmd_mode.so $(LIBPATH)
	@-cp .gdbargs $(BASE)
	@-cp conf/inspircd.quotes.example $(CONPATH)
	@-cp conf/inspircd.rules.example $(CONPATH)
	@-cp conf/inspircd.motd.example $(CONPATH)
	@-cp conf/inspircd.helpop-full.example $(CONPATH)
	@-cp conf/inspircd.helpop.example $(CONPATH)
	@-cp conf/inspircd.censor.example $(CONPATH)
	@-cp conf/inspircd.filter.example $(CONPATH)
	@-cp conf/key.pem $(CONPATH)
	@-cp conf/cert.pem $(CONPATH)
	@-cp docs/inspircd.conf.example $(CONPATH)
	${MAKE} modinstall

modinstall: mods
	${MAKE} -C src/modules DIRNAME="src/modules" $(MAKEARGS) modinst
	@echo ""
	@echo "*************************************"
	@echo "*        INSTALL COMPLETE!          *"
	@echo "*                                   *"
	@echo "* It is safe to ignore any messages *"
	@echo "* related to copying of conf files. *"
	@echo "*                                   *"
	@echo "* REMEMBER TO EDIT YOUR CONFIG FILE *"
	@echo "*************************************"

module:
	${MAKE} -C src/modules DIRNAME="src/modules" $(MAKEARGS) ${name}

clean:
	@echo Cleaning...
	@rm -rf src/*.so src/*.dylib src/*.o src/inspircd src/modules/*.so src/modules/*.o *~ src/*~ src/modules/*~ src/modules/extra/*~ src/modes/*~ src/modes/*.o src/modes/*.a src/modules/*/*.o src/modules/*/*.so
	@echo Completed.

modclean:
	rm -rf modules/*.so
	rm -rf src/modules/*.so
	rm -rf src/modules/*.o
	rm -rf src/modules/*/*.so
	rm -rf src/modules/*/*.o
	rm -rf lib/*.so
	rm -f bin/inspircd

squeakyclean: distclean

launchd_dir:
	@-install -d -m $(INSTMODE) ${LAUNCHDPATH}

configureclean:
	rm -f .config.cache
	rm -f src/modules/Makefile
	rm -f src/Makefile
	rm -f Makefile
	rm -f include/inspircd_config.h
	rm -f include/inspircd_se_config.h

distclean: modclean clean configureclean

