/*       +------------------------------------+
 *       | Inspire Internet Relay Chat Daemon |
 *       +------------------------------------+
 *
 *  InspIRCd: (C) 2002-2009 InspIRCd Development Team
 * See: http://wiki.inspircd.org/Credits
 *
 * This program is free but copyrighted software; see
 *            the file COPYING for details.
 *
 * ---------------------------------------------------
 */

#include "inspircd.h"

/* $ModDesc: Provides support for unreal-style umode +B */

/** Handles user mode +B
 */
class BotMode : public SimpleUserModeHandler
{
 public:
	BotMode(InspIRCd* Instance) : SimpleUserModeHandler(Instance, 'B') { }
};

class ModuleBotMode : public Module
{

	BotMode* bm;
 public:
	ModuleBotMode(InspIRCd* Me)
		: Module(Me)
	{

		bm = new BotMode(ServerInstance);
		if (!ServerInstance->Modes->AddMode(bm))
			throw ModuleException("Could not add new modes!");
		Implementation eventlist[] = { I_OnWhois };
		ServerInstance->Modules->Attach(eventlist, this, 1);
	}


	virtual ~ModuleBotMode()
	{
		ServerInstance->Modes->DelMode(bm);
		delete bm;
	}

	virtual Version GetVersion()
	{
		return Version("$Id: m_botmode.cpp 11223 2009-03-15 12:42:35Z psychon $",VF_COMMON|VF_VENDOR,API_VERSION);
	}

	virtual void OnWhois(User* src, User* dst)
	{
		if (dst->IsModeSet('B'))
		{
			ServerInstance->SendWhoisLine(src, dst, 335, std::string(src->nick)+" "+std::string(dst->nick)+" :is a bot on "+ServerInstance->Config->Network);
		}
	}

};


MODULE_INIT(ModuleBotMode)
