/* 
 * $Id: x11info.c,v 1.6 2003/02/16 12:43:37 isizaka Exp isizaka $
 * 
 * This file is part of "Ngraph for X11".
 * 
 * Copyright (C) 2002, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for X11" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for X11" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/**
 *
 * $Log: x11info.c,v $
 * Revision 1.6  2003/02/16 12:43:37  isizaka
 * for release 6.13.18
 *
 * Revision 1.5  2002/07/06 08:57:25  isizaka
 * change to GPL.
 *
 * Revision 1.4  1999/05/08 13:31:30  isizaka
 * for release 6.03.02
 *
 * Revision 1.3  1999/04/11 06:09:20  isizaka
 * *** empty log message ***
 *
 * Revision 1.2  1999/03/20 12:32:54  isizaka
 * minor change
 *
 * Revision 1.1  1999/03/17 13:29:01  isizaka
 * Initial revision
 *
 *
 **/

#include <Xm/XmAll.h>

#include "ngraph.h"
#include "object.h"

#include "x11gui.h"
#include "ox11menu.h"
#include "x11menu.h"
#include "x11info.h"

void InfoWinDrawText(GC gc)
{
  int x,y,len,j,k;
  Display *disp;
  Window win;
  struct InfoWin *d;

  d=&(NgraphApp.InfoWin);
  if (d->str==NULL) return;
  disp=XtDisplay(d->text);
  win=XtWindow(d->text);
  XSetForeground(disp,gc,black);
  x=FWidth;
  y=FAscent;
  len=0;
  j=k=0;
  while (TRUE) {
    if (d->str[j]=='\0') {
      XDrawString(disp,win,gc,x,y,d->str+k,len);
      k=j+1;
      len=0;
      break;
    } else if (d->str[j]=='\n') {
      XDrawString(disp,win,gc,x,y,d->str+k,len);
      k=j+1;
      len=0;
      y+=FHeight;
    } else len++;
    j++;
  }
}

void InfoWinDrawInfoText()
{
  struct InfoWin *d;
  GC gc;

  d=&(NgraphApp.InfoWin);
  if (d->text==NULL) return;
  gc=XCreateGC(XtDisplay(d->text),XtWindow(d->text),0,0);
  XClearArea(XtDisplay(d->text),XtWindow(d->text),0,0,0,0,FALSE);
  InfoWinDrawText(gc);
  XFreeGC(XtDisplay(d->text),gc);
}

void InfoWinUpdate(int clear)
{
  struct InfoWin *d;

  d=&(NgraphApp.InfoWin);
  if (d->text==NULL) return;
  XClearArea(XtDisplay(d->text),XtWindow(d->text),0,0,0,0,TRUE);
}

void InfoWinExpose(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct InfoWin *d;
  XmDrawingAreaCallbackStruct *dd;
  XExposeEvent *e;
  GC gc;

  d=&(NgraphApp.InfoWin);
  if (d->text==NULL) return;
  dd=(XmDrawingAreaCallbackStruct *)call_data;
  e=(XExposeEvent *)(dd->event);
  gc=XCreateGC(e->display,e->window,0,0);
  InfoWinDrawText(gc);
  XFreeGC(e->display,gc);
}

void InfoWinUnmap(Widget w,XtPointer client_data,XtPointer call_data)
{
  struct InfoWin *d;
  Position x,y,x0,y0;
  Dimension w0,h0;

  d=&(NgraphApp.InfoWin);
  if (d->Win!=NULL) {
    XtVaGetValues(d->Win,XmNx,&x,XmNy,&y,
                         XmNwidth,&w0,XmNheight,&h0,NULL);
    menulocal.dialogwidth=w0;
    menulocal.dialogheight=h0;
    XtTranslateCoords(TopLevel,0,0,&x0,&y0);
    menulocal.dialogx=x-x0;
    menulocal.dialogy=y-y0;
    XtDestroyWidget(d->Win);
    d->Win=NULL;
    d->text=NULL;
    XmToggleButtonSetState(XtNameToWidget(TopLevel,"*windowmenu.button_5"),
                           False,False);
  }
}

void CmInformationWindow(Widget w,XtPointer client_data,XtPointer call_data)
{
  Arg al[20];
  Cardinal ac;
  Widget dlg;
  unsigned int width,height;
  Position x,y;
  struct InfoWin *d;

  d=&(NgraphApp.InfoWin);
  if (d->Win!=NULL) {
    XtUnmanageChild(d->Win);
  } else {
    if (menulocal.dialogwidth==CW_USEDEFAULT) width=FWidth*30;
    else width=menulocal.dialogwidth;
    if (menulocal.dialogheight==CW_USEDEFAULT) height=FHeight*20;
    else height=menulocal.dialogheight;
    ac=0;
    XtSetArg(al[ac],XmNborderWidth,1);ac++;
    XtSetArg(al[ac],XmNdialogStyle,XmDIALOG_MODELESS); ac++;
    XtSetArg(al[ac],XmNautoUnmanage,FALSE); ac++;
    XtSetArg(al[ac],XmNwidth,width); ac++;
    XtSetArg(al[ac],XmNheight,height); ac++;
    if ((menulocal.dialogx!=CW_USEDEFAULT)
     && (menulocal.dialogy!=CW_USEDEFAULT)) {
      XtTranslateCoords(TopLevel,menulocal.dialogx,menulocal.dialogy,&x,&y);
      x-=menulocal.framex;
      y-=menulocal.framey;
      if (x<0) x=0;
      if (y<0) y=0;
      XtSetArg(al[ac],XmNdefaultPosition,False); ac++;
      XtSetArg(al[ac],XmNx,x); ac++;
      XtSetArg(al[ac],XmNy,y); ac++;
    } else {
      XtSetArg(al[ac],XmNdefaultPosition,True); ac++;
    }
    XtManageChild(dlg=XmCreateFormDialog(TopLevel,"informationwindow",al,ac));
    d->Win=dlg;
    XtAddCallback(dlg,XmNunmapCallback,InfoWinUnmap,NULL);
    ac=0;
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM); ac++;
    XtSetArg(al[ac],XmNalignment,XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(al[ac],XmNbackground,WhitePixel(XtDisplay(TopLevel),0)); ac++;
    XtSetArg(al[ac],XmNwidth,width); ac++;
    XtSetArg(al[ac],XmNheight,height); ac++;
    XtSetArg(al[ac],XmNborderWidth,0);ac++;
    XtManageChild(d->text=XmCreateDrawingArea(dlg,"window",al,ac));
    XtAddCallback(d->text,XmNexposeCallback,InfoWinExpose,NULL);
    XmToggleButtonSetState(XtNameToWidget(TopLevel,"*windowmenu.button_5"),
                           True,False);
  }
}

