/*
    main.cpp
    OpenAG
     
    Created by Eric Seidel on Fri Nov 30 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.h"

#include <signal.h>

#include "AGMain.h"
#include "AGInit.h"

bool exiting = false;
bool libc_qsort_is_safe = true;

void handleEXITSIGNAL(int signo);

struct server_status STATS = server_status();	/* ALL THE CURRENT STATUS INFORMATION */
bool notDone = true;

int main(int argc, const char * argv[])
{   
    printf("Welcome to OpenAG version %s\n", OPENAG_VERSION);
    
    if (NULL != 0)
        err_exit("I make the obviously BAD assumption that NULL == 0 in OpenAG, this is not the case on your platform... therefore things will not right... Exiting...\n");
    
    /* Before we do anything else, set up signal handlers */
    struct sigaction act, oact;
    act. sa_handler = &handleEXITSIGNAL;
    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    if (sigaction(SIGTERM, &act, &oact) < 0)
        err_exit("Sorry, an error occored while try to set up the signal handlers, I can't continue.\n");
    if (sigaction(SIGINT, &act, &oact) < 0)
        err_exit("Sorry, an error occored while try to set up the signal handlers, I can't continue.\n");
    
    
    setBaseDirectory(STATS, NULL);
    
    /* ReadPreferences -- or set defaults */
    readPrefs(STATS);
    #if AGDEBUGLEVEL > 3
    printf("read prefs\n");
    #endif
    /* Read Shares */
    readShares(STATS);
    #if AGDEBUGLEVEL > 3
    printf("read shares\n");
    #endif
    
    /* Read Resumes */
    readResumes(STATS);
    #if AGDEBUGLEVEL > 3
    printf("read resumes\n");
    #endif
    
    printf("Please wait just a moment, while we connect to the central servers...\n\n");
    
    /* Initialize the Client and Connect it to an information Server */
    clientInit(STATS);
    
    #if AGDEBUGLEVEL > 4
    STATS.Shares->printList();
    #endif

    /******MAIN LOOP ******/

    while(notDone)
    {
        #if AGDEBUGLEVEL > 3
        printf("TOP OF WHILE LOOP\n");
        #endif
        notDone = doMainLoop(STATS);
    }

    return 0;
}

void handleEXITSIGNAL(int signo)
{
        libc_qsort_is_safe = false; /* I get SGFAULT in qsort under the signal hendler, so this marks to FileList to avoid using glibc's qsort*/
    if (exiting)
    {
        printf("\n\nreceived second exit signal, exiting immeadiatly!  Databases may now be corrupt.\n");
        exit(1);
    }

    exiting = true;

    printf("\n\n received Exit signal.\n Closing all files and writing databases to disk...\n");

    deleteAllConnectionRecords(STATS);

    if(STATS.Resumes != NULL && STATS.Resumes != 0)
    {
        if (STATS.Resumes->writeToDisk(STATS.setDisplayedFileSystemChange) != 0)
            err_print("Error encountered while writting Resumes database to disk.\n");
    }

    if(STATS.Shares != NULL && STATS.Shares != 0)
    {
        if (STATS.Shares->writeToDisk(STATS.setDisplayedFileSystemChange) != 0)
            err_print("Error encountered while writting Shares database to disk.\n");
    }

    printf("Thank you for using OpenAG\n");
    exit(0);
}


