/*
    AGPrefs.cpp
    OpenAG, libOpenAG, OpenAG X
 
    Created by Eric Seidel on Thr Nov 22 2001.
 
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.h"

#include <fcntl.h>

#include "AGPrefs.h"
#include "AGMain.h"
#include "AGInit.h"

AGPrefs::AGPrefs()
{
    #if AGDEBUGLEVEL > 4
    printf("creating prefs object\n");
    #endif
    
    /* Set everybody to NULL, just incase we don't get them that way */
    EmailAddress 			= NULL;
    Password 				= NULL;
    
    IsGoldAccount			= false;
    
    ShareDirectories			= NULL;
    IncompleteDownloadsDirectory 	= NULL;
    FinishedDownloadsDirectory		= NULL;
    
    SpecifiedIP 			= NULL;
    
    IncomingLimit 			= -1;
    OutgoingLimit 			= -1;
}


AGPrefs::~AGPrefs()
{
    #if AGDEBUGLEVEL > 2
    printf("*********WOH.  DELETEING PREFS... WHY???\n");
    #endif
    if (EmailAddress != NULL && EmailAddress !=0) delete (EmailAddress);
    if (Password != NULL && Password !=0) delete (Password);
    if (ShareDirectories != NULL && ShareDirectories !=0)
    {
        int x = 0;
        while(ShareDirectories[x] != NULL)
        {
            delete (ShareDirectories[x]);
            x++;
        }
        delete(ShareDirectories);
    }
    // that should be it.
    if (IncompleteDownloadsDirectory != NULL) delete(IncompleteDownloadsDirectory);
    if (FinishedDownloadsDirectory != NULL) delete(FinishedDownloadsDirectory);
    if (SpecifiedIP != NULL) delete(SpecifiedIP);
}



int AGPrefs::readFromDisk(const char* BaseDirectory)
{
    #if AGDEBUGLEVEL > 2
    printf("******READING IN PREFS******\n");
    #endif
    
    int resultfd;
    int O_flags;
    
    O_flags = (O_RDONLY);
    
    char* tempPath = new char[PATH_MAX];
    strcpy(tempPath, BaseDirectory);
    strcat(tempPath, "/user.txt");
    
    if ( ( resultfd = open(tempPath, O_flags) ) < 0 )
    {
        delete(tempPath);
        return (-1); // they will check errno
    }
    delete(tempPath);
    
    /* read in data */
    /* FIX - this is just temporaray... no error checking */
    
    int tempSize = 2000;
    char* temp = new char[tempSize];
    char* wptr = temp;
    char* rptr = temp;
    bool gotEOF = false;
    int re;
    
    int linesRead = 0;
    
    for (;;)
    {
        #if AGDEBUGLEVEL > 3
        printf("trying to read %i\n", temp + tempSize - wptr);
        #endif
        if( (re = read(resultfd, wptr, temp + tempSize - wptr) ) < 0)
            return(-1);
        else if (re == 0)
        {
            #if AGDEBUGLEVEL > 3
            printf("re = %i, reached EOF\n", re);
            #endif
            gotEOF = true;
        }
        else
            wptr += re;
            
        while ( (wptr-rptr) > 0 )  // there is still stuff to read.
        {
            #if AGDEBUGLEVEL > 3
            printf("parsing prefs from file\n");
            #endif

            char* newLine = (char*)memchr(rptr, '\n', wptr-rptr);
            if (gotEOF) newLine = wptr; // in case they did not terminate the file with a new line.
            else if (newLine == NULL)
            {
                #if AGDEBUGLEVEL > 3
                printf("no newline char in the current buffer, waiting for more\n");
                #endif
                break;
            }
            
            if (linesRead == 0)
            {
                if (EmailAddress != NULL) delete (EmailAddress);
                EmailAddress = new char[newLine-rptr + 1];
                memcpy(EmailAddress, rptr, newLine-rptr);
                EmailAddress[newLine-rptr] = '\0';
            }
            else if (linesRead == 1)
            {
                if (Password != NULL) delete (Password);
                Password = new char[newLine-rptr + 1];
                memcpy(Password, rptr, newLine-rptr);
                Password[newLine-rptr] = '\0';
            }
            else
            {
                #if AGDEBUGLEVEL > 2
                printf("All remaining lines will be treated as share directories\n");
                #endif
                /* FIX -- Implement reading of share directories from prefs file */
                
                err_print("Sorry, share directories are not currently read from the preferences file.  Share Directories default to \"%s\".  This will be fixed soon.\n", DEFAULT_DOWNLOADS_DIRECTORY);
                gotEOF = true;
                break;
            }
            linesRead++;
            #if AGDEBUGLEVEL > 3
            printf("newLine - rptr: %i\n",newLine - rptr);
            #endif
            rptr += (newLine - rptr) + 1; // adjusts read pointer, including \n character.
            if ((newLine - rptr) > 1) linesRead++; //ignores empty lines... don't need to.. but it's easy and nice.
        }
            
        if (gotEOF)
        {
            #if AGDEBUGLEVEL > 2
            if ((wptr - rptr) > 0) printf("SOMETHING FISHY WITH PREF FILE, NOT EVERYTHING READ\n");
            #endif
            break;
        }
        else
        {
            #if AGDEBUGLEVEL > 4
            printf("wptr - rptr: %i\n", wptr - rptr);
            #endif
            doAdjustBuffer(temp, rptr, wptr, true);
        }
        
        if (wptr == (temp + tempSize)) // buffer still full after adjust.
        {
            #if AGDEBUGLEVEL > 2
            printf("Woh.  Error reading from pref file, read buffer full, yet no new line character\n");
            #endif
            close(resultfd);
            delete(temp);
            return(-1);
        }
    }
    
    // clean up.
    delete(temp);
    close(resultfd);
    
    /* Temporary - need to read them */
    ShareDirectories = new ShareFolder*[2];
    ShareFolder* defaultFolder = new ShareFolder();
    defaultFolder->FolderPath = strdup(DEFAULT_DOWNLOADS_DIRECTORY);
    defaultFolder->ScanDepth  = AG_DEFAULT_SCAN_DEPTH;
    ShareDirectories[0] = defaultFolder;
    ShareDirectories[1] = NULL;
    
    #if AGDEBUGLEVEL > 4
    printf("test: %s\n",ShareDirectories[0]->FolderPath);
    #endif
    IncompleteDownloadsDirectory = strdup(DEFAULT_TEMP_DIRECTORY);
    FinishedDownloadsDirectory = strdup(DEFAULT_DOWNLOADS_DIRECTORY);
    
    IsGoldAccount = false;
    
    IncomingLimit = -1;
    OutgoingLimit = -1;
    
    
    /* Fix paths */
    makePathAbsolute(IncompleteDownloadsDirectory, BaseDirectory);
    makePathAbsolute(FinishedDownloadsDirectory, BaseDirectory);
    for(int x = 0; ; x++)
    {
        if (ShareDirectories[x] == NULL) break;
        makePathAbsolute(ShareDirectories[x]->FolderPath, BaseDirectory);
    }
    
    //#if AGDEBUGLEVEL > 1
    printf("EmailAddress: %s\n", EmailAddress);
    printf("Password: %s\n", Password);
    //#endif
    return 0; //success
}


void makePathAbsolute(char* &Path, const char* BaseDirectory)
{
    #if AGDEBUGLEVEL > 3
    printf("making path: %s absolute, based on directory: %s\n", Path, BaseDirectory);
    #endif
    
    if (Path == 0 || Path == NULL) return;
    
    if ( (Path[0] != '/') && (Path[0] != '~') )
    {
        int size = PATH_MAX;
        char* temp = new char[size];
        memset(temp, '\0', size);
        
        if (BaseDirectory != NULL)
            strcpy(temp,BaseDirectory);
        else
        {
            err_print("BaseDirectory was passed as NULL!!!\n");
        }
        
        if(BaseDirectory[strlen(BaseDirectory)] != '/')
            strcat(temp, "/");
        strcat(temp, Path);
        delete(Path);
        Path = strdup(temp);
        delete(temp);
        return;
    }
        
    if (Path[0] == '~')
    {
        char* temp = new char[PATH_MAX];
        memset(temp, '\0',PATH_MAX);
	strcpy(temp, getenv("HOME"));
        char temp2 = temp[strlen(temp) - 1];
        strcpy(temp + strlen(temp) - 1, Path);
        temp[strlen(getenv("HOME")) - 1] = temp2;
        delete(Path);
        Path = strdup(temp);
        delete(temp);
        return;
    }
    
    // we're allowing it to return an invalid...
    
    //#if AGDEBUGLEVEL > 3
    printf("absoluted path: %s\n", Path);
    //#endif
    return;
}

