/*
    FileInfo.cpp
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Thu Feb 21 2002.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.h"

#include "FileInfo.h"
#include "error.h"

#include "mp3info.h"

#include <limits.h>  /* for PATH_MAX */

#ifdef __WIN32__
#include <windows.h>
#include <io.h>
#endif

//const char* libmp3info_error_string(int error);


//char *file_to_check = "/mnt/c/milk.MP3";
//char *file_name = "milk.MP3";
//char *file_path = "/mnt/c/";
//char *file_extension = "MP3";

extern "C"  int read_mp3_data( long unsigned size , mp3_file_info *current , unsigned long int max_size,unsigned long int min_size ,unsigned long int max_sec ,unsigned long int min_sec);

extern char *genres_list[];

int readMP3info(FileRecord* theRecord)
{
    if (theRecord == NULL)
    {
        err_print("passed a NULL record to readMP3info, PLEASE REPORT.\n");
        return (-1);
    }
    
    struct stat stat_buf;
    int size = PATH_MAX;
    char* file_to_check = new char[size];
    snprintf(file_to_check, size, "%s/%s", theRecord->DirectoryName, theRecord->DiskFileName);
    
    if (stat(file_to_check , &stat_buf) != 0)
    {
        err_print("error getting reading file info\n");
        delete(file_to_check);
        return (-1);
    }
    
    char *file_name = strdup(theRecord->DiskFileName);
    char *file_path = new char[strlen(theRecord->DirectoryName)+2];
    strcpy(file_path, theRecord->DirectoryName);
    strcat(file_path, "/\0");
    char *file_extension = "mp3";

    
    mp3_file_info the_file_info;
    memset(&the_file_info , 0 , sizeof(mp3_file_info));

    //the_file_info.struct_size = sizeof(mp3_file_info);
    //the_file_info.version = MP3LIST_H_VERSION;
    the_file_info.file_name 		= file_name;
    the_file_info.file_path 		= file_path;
    the_file_info.file_extantion 	= file_extension;
    the_file_info.function_list 	= NULL;

    //printf("his code start\n");

    int result;
    if ((result = read_mp3_data( stat_buf.st_size , &the_file_info , 0 , 0 , 0 , 0 ) ) < 0)
    {
        err_print("LibMp3Info encountered an error while reading file: %s of directory: %s, the error was #%i which means: %s.  This file will not be added to your shared files.\n", theRecord->DiskFileName, theRecord->DirectoryName, result, libmp3info_error_string(result));
        return (-1);
    }
    
    //printf("his code end\n");
    
    #if AGDEBUGLEVEL > 7
    
    printf( "struct returned:\n"
    "file name - %s\n"
    "title - %s\n"
    "artist - %s\n"
    "album - %s\n"
    "comment - %s\n"
    "year - %s\n"
    "genre - %d\n"
    "genre string - %s\n",
    the_file_info.file_name,
    the_file_info.title,
    the_file_info.artist,
    the_file_info.album,
    the_file_info.comment,
    the_file_info.year,
    the_file_info.genre,
    the_file_info.genre==GENRE_MAGIC?the_file_info.genre_string:genres_list[the_file_info.genre]);
    #endif
    
    theRecord->HasID3v1		= the_file_info.id3v1found;
    if (theRecord->HasID3v1)
    {
        if (the_file_info.title)
            theRecord->ID3v1_Title 	= strdup(the_file_info.title);
        if (the_file_info.artist)
            theRecord->ID3v1_Artist 	= strdup(the_file_info.artist);
        if (the_file_info.album)
            theRecord->ID3v1_Album 	= strdup(the_file_info.album);
    }
    
    #if AGDEBUGLEVEL > 7
    printf( "v2 info:\n"
    "title - %s\n"
    "artist - %s\n"
    "album - %s\n"
    "comment - %s\n"
    "year - %s\n"
    "track number - %d\n"
    "genre string - %s\n",
    the_file_info.v2_title,
    the_file_info.v2_artist,
    the_file_info.v2_album,
    the_file_info.v2_comment,
    the_file_info.v2_year,
    the_file_info.v2_track_number,
    the_file_info.v2_genre_string);
    #endif
    
    theRecord->HasID3v2		= the_file_info.id3v2found;
    if (theRecord->HasID3v2)
    {
        if (the_file_info.v2_title)
            theRecord->ID3v2_Title	= strdup(the_file_info.v2_title);
        if (the_file_info.v2_artist)
            theRecord->ID3v2_Artist 	= strdup(the_file_info.v2_artist);
        if (the_file_info.v2_album)
            theRecord->ID3v2_Album 	= strdup(the_file_info.v2_album);
        theRecord->ID3v2_Track 		= the_file_info.v2_track_number;
    }
    
    theRecord->FileSize		= stat_buf.st_size;
    theRecord->FileLastModified = stat_buf.st_mtime;
    
    /*
    printf("br: %li  sr: %i  sl: %li\n", 
        the_file_info.bit_rate, 
        the_file_info.samp_rate, the_file_info.length_in_sec);
    */
    
    if (the_file_info.bit_rate)
    {
        theRecord->Bitrate		= the_file_info.bit_rate;
    }
    else
    {
        printf("bitrate returned 0, assuming 128\n");
        theRecord->Bitrate = 128;
    }
        
    if (the_file_info.length_in_sec)
    {
        theRecord->SongLength	= the_file_info.length_in_sec;
    }
    else
    {
        theRecord->SongLength = (stat_buf.st_size/(theRecord->Bitrate*125));
        printf("songlength returned 0, guessing: %li\n", theRecord->SongLength);
    }
    
    #if AGDEBUGLEVEL > 2
    printf("file: %s size: %li, bitrate: %d, songlength: %li\n", theRecord->DiskFileName, theRecord->FileSize,
        theRecord->Bitrate, theRecord->SongLength);
    #endif
    
    // what do to with the Audiogalaxy tag?

    //printf("his code start2\n");

    if(the_file_info.function_list)
    {
        finialization_functions_list *func , *func2;
        for(func = the_file_info.function_list ; func ; func = func2)
        {
            func2 = func->next;// the function should also free its call structure, so this should be done before calling it.
            if(func->function)
            {
                func->function(func , &the_file_info);
            }
        }
    }
    
    //printf("his code end2\n");

    delete(file_to_check);
    
    delete(file_name);
    delete(file_path);
    
    return 0;
}


/* // now done in the mp3info library itself
const char* libmp3info_error_string(int error)
{
    switch(error)
    {
    case MP3INFO_ENOMEM:
        return "ran out of memory while attempting to that operation\0"; break;
    case MP3INFO_EBADFILE:
        return "\"bad file\" encountered.  Author says: This error (MP3INFO_EBADFILE) is returned when  the file is not an MPEG audio file (I support MPEG versions 1,2 and 2.5, and all 3 layers)\0"; break;
    case MP3INFO_ECORRUPTEDFILE:
        return "\"corrupted file\" encountered.  Author says: This error (MP3INFO_ECORRUPTEDFILE) is only used internally, to signal that the ID3v2 tag/header is broken. the library never returns this value.\0"; break;
    case MP3INFO_EIO:
        return "IO error while reading that file\0"; break;
    case MP3INFO_EFILTERED:
        return "\"EFILTERED\" error.  Author says: There is an internal filtering mechanisem in my library, which allows you to filter only files longer then specified length (the min_sec parameter) and shorter then other length (the max_sec parameter). you recieve this \"error\"(MP3INFO_EFILTERED) if the file is a valid MPEG audio file, but should be filtered. if the max_sec and min_sec parameters are 0, the library will never return this value.\0"; break;
    default:
        return "unknown error"; break;
    }
}
*/

