/*
    AGMain.h
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Fri Nov 02 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _AGMAIN_H_
#define _AGMAIN_H_


#include "common.h"

#include "FileList.h"	/* for FileList */
#include "AGConnection.h" /* for connection/redirectionconnection */
#include "AGPrefs.h"	/* for AGPrefs */
#include "error.h"	/* for err_exit() */
#include <limits.h>	/* for PATH_MAX */


#define OPENAG_VERSION "1.1.1 (cvs 1.38)"
#define OPENAG_VERSION_URL "1.1.1%20(cvs 1.38)"
#define VERSION_STRING "0.520L"
#define AG_OPENAG_HOMEPAGE      "http://homepage.mac.com/macdomeeu/dev/current/openag/"
#define AG_OPENAG_DOWNLOADPAGE  "http://homepage.mac.com/macdomeeu/dev/current/openag/"


// what are these two for?
#define SERVER_MESSAGE	true
#define PEER_MESSAGE	false


#define MAXCONNECTIONS	21

/* for Client Status */

#define CS_DISCONNECTED			0
#define CS_INITIALIZING			1
#define CS_CONNECTING_REDIRECT		2
#define CS_CONNECTING_INFO_SERVER	3
#define CS_CONNECTED			4
#define CS_SENDING_SHARES		5
#define CS_WAITING_SHARE_RESPONSES	6
#define CS_DISCONNECTING		7



struct server_status
{        
    
    server_status()
    /*
    {
        server_status(NULL);
    }
    
    server_status(const char * basePath)
    */
    {
        bzero(connections, MAXCONNECTIONS * sizeof(connection));
        
        #if AGDEBUGLEVEL > 3
        //printf("entering server_status contstruction, with path: %s\n", );
        #endif
        current = -1;
        FD_ZERO(&rset);
        FD_ZERO(&wset);
        maxfd = -1;
        nConnections = 0; // for clientInit();
        myIP = NULL;
        Shares = NULL;
        Resumes = NULL;
        Prefs = NULL;
        
        setDisplayedServerStatus = NULL;
        setDisplayedTransferComplete = NULL;
        
        BaseDirectory = NULL;
        FinishedDownloadsAreShared = false;
        
        #if AGDEBUGLEVEL > 3
        printf("completed server_status construction\n");
        #endif
    }
    
    ~server_status()
    {
        #if AGDEBUGLEVEL > 4
        printf("******* server_status destructor called!  WHY? *****\n");
        #endif
        if (Shares != NULL && Shares != 0) delete(Shares);
        if (Resumes != NULL && Resumes != 0) delete(Resumes);
        if (Prefs != NULL && Prefs != 0) delete(Prefs);
        if (BaseDirectory != NULL && BaseDirectory != 0) delete(BaseDirectory);
        setDisplayedServerStatus = NULL;
        setDisplayedTransferComplete = NULL;
        if (myIP != NULL && myIP != 0)
            delete(myIP);
    }
    
    /* The most important variable of all */
    unsigned short int		clientStatus;
    
    char*	redirectionDNS; // NOT AGString
    char*	myIP;		// NOT AGString
    
    /* Most all of the data is held in this one */
    connection	connections[MAXCONNECTIONS];
    short	current; // tells us which one we're working on right now.
    
    short	nConnections; // tells us how many we have open right now.
    
    /* File Descriptor Stuff */
    fd_set	rset;
    fd_set	wset;
    long	maxfd; // the highest numbered file descriptor
    
    /* Keep Alive Stuff */
    bool	sendKeepAlive; // probably should be rolled into client status.
    time_t	LastKeepAlive;
    
    void (*setDisplayedServerStatus) (char* theStatus);
    void (*setDisplayedTransferComplete) (connection c);
    void (*setDisplayedFileSystemChange) (char* thePath);
    
    bool FinishedDownloadsAreShared;
    
    FileList*	Shares;
    FileList*   Resumes;
    AGPrefs*	Prefs;
    
    char*  BaseDirectory; // could be AGString, might not need it.
    
    time_t	old_time;
    timeval	select_timer;
    
    /* Bandwidth limiting stuff */
    timeval	lastIncomingCheck;
    timeval	lastOutgoingCheck;
    
    long	incomingByteCount;
    long	outgoingByteCount;
};


/* MAKING NEW CONNECTIONS */
int handleConnectionConnecting(server_status &STATS);
int  handleConnectionAccepting(server_status &STATS);
void handleNewConnection(int i, server_status &STATS);


 /* READING FROM A SOCKET */
int  handleReadFromSocket(server_status &STATS);

int handleIncomingFileRequest(server_status &STATS);
int handleIncomingFileRequestResponse(server_status &STATS);
int handleIncomingDataFromPeer(server_status &STATS);
int handleIncomingDataFromInfoServer(server_status &STATS);


/* READING FROM A FILE */
int openCorrespondingFile(server_status &STATS);

int handleIncomingDataFromFile(server_status &STATS);
void makePathAbsolute(char*  &Path, const char*  BaseDirectory);


/* WRITING TO A SOCKET */
void handleOutgoingFileRequest(server_status &STATS);
void handleOutgoingFileRequestResponse(server_status &STATS);
int  handleOutgoingDataToSocket(server_status &STATS);


/* WRITING TO A FILE */
int handleOutgoingDataToFile(server_status &STATS);
void handleFileCompletelyreceived(server_status &STATS);
int getUnusedFileName(char* &FileName, const char* FileDirectory);


/* UPKEEP FUNCTIONS */
bool doMainLoop(server_status &STATS);

void handleBandwidthLimits(server_status &STATS, fd_set &ws, fd_set &rs);
void handleTimeAndKeepAlive(server_status &STATS);
void sendKeepAlive(server_status &STATS);
void sendFileTransferState(int i, server_status &STATS, int ClosureStatus);



/* MANNAGE CONNECTION RECORDS */

int  getNewConnectionRecord(server_status &STATS);

void deleteConnectionRecord(int i, server_status &STATS);
void deleteAllConnectionRecords(server_status &STATS);

int getKPS(int i, server_status &STATS);

void adjustBuffers(int i, server_status &STATS);
void doAdjustBuffer(char* buf, char* &rPtr, char* &wPtr, bool aggressiveClear);


/* Handle environment specific file operations */
int AGMove(const char* PathFrom, const char* PathTo);

// string conversions
unsigned short int string_serverToLocal(unsigned char* &newString, unsigned const char* oldString, unsigned short int theLength);
unsigned short int string_localToServer(unsigned char* &newString, unsigned const char* oldString, unsigned short int theLength);


#endif


