 /*
    AGMessage.h
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Fri Nov 02 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _AGMESSAGE_H_
#define _AGMESSAGE_H_

#include "AGMain.h"

#define CLIENT_SERVER_STARTSIGNAL 1163907285

#define DO_TERMINATE		true
#define DONT_TERMINATE		false

#define AG_MESSAGE_INCOMPLETE		0
#define AG_MESSAGE_COMPLETE		1
#define AG_MESSAGE_BAD_STARTSIGNAL	2


class AGMessage
{
public:
    char * ReadPointer;
    char * WritePointer;

    /** INCOMING PACKET CONSTRUCTOR **/
    AGMessage(char* ReadBuffer, unsigned int BufferLength, bool isServerMessage);
    
    /** OUTGOING PACKET CONSTRUCTOR **/
    AGMessage(int s);
    
    /** DESTRUCTOR **/
    ~AGMessage();
    
    /** GENERAL STUFF **/
    bool isSendPacket();
    int  getCompleteMessageSize();
    int AGMessage::getCompleteMessageData(char* &deleteMe);
    int getDataLength();
    void dumpHex();

    /****** FOR INCOMING PACKETS **********/
    
    unsigned int 	read_int();
    unsigned short 	read_short();
    unsigned char 	read_byte();
    int		 	read_string(char* &MyBuff, bool terminate);
    void	 	read_string(char* &MyBuff, unsigned short l);

    int getMessageStatus();
    int getType();
    
    /****** FOR OUTGOING PACKETS **********/
    
    void write_int(unsigned int data);
    void write_short(unsigned short data);
    void write_byte(unsigned char data);
    void write_string(char* data, unsigned short l, bool includelength);
    void write_string(char* q);
    void write_zeros(unsigned short howMany);
    void adjustBuffer();
    void setType(int type);
    int sendMessage();
    void queueMessage(int i, server_status &STATS);
    
    
    
private:
    int			TheSocket;
    unsigned int	MessageSize;
    short		MessageType;
    unsigned int	MessageID;
    unsigned int	StartSignal;

    char* 		DataBuffer;	// NOT AGMessage
    unsigned int 	BufferSize;

    bool SendPacket;
    int MessageStatus;
};

#endif


