/*
    ParseMessage.h
    OpenAG, libOpenAG, OpenAG X
        
    Created by Eric Seidel on Wed Oct 31 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _AGPARSEMESSAGE_H_
#define _AGPARSEMESSAGE_H_

/* For more documentation info, see the OpenAG Homepage:
   http://homepage.mac.com/macdomeeu/dev/current/openag  */


#define LOGIN					0
#define LOGOFF					1

#define NEW_SHARE				2
#define OLD_SHARE				3

#define READY_FOR_TRANSFER			5

#define FILE_TRANSFER_STATE			6

#define FTS_DOWNLOAD_COMPLETE		0
#define FTS_INTERNAL_ERROR		1 /* couldn't find file */
#define FTS_TIMEOUT			2 /* self explanitory */
#define FTS_SETTING_UP			3 /* sent after we have made the connection */
#define FTS_COULD_NOT_CONNECT		4 /* self explanitory */
#define FTS_CONNECTION_CLOSED		5

#define FTS_PORT_NOT_AVAILABLE		7 /* can't bind() there */
#define FTS_STOPPED			8 /* asked to stop, we did */
#define FTS_RESET_CONNECTION		9 /* our user chose to reset the connection */


#define READY_TO_SEND_SHARES			7
#define SEND_SHARES_STAND_BY			8
#define SEND_SHARES				9
#define FILE_TRANSFER				10
#define STOP_FILE_TRANSFER			11

#define NEW_SHARE_RESPONSE			13

#define WRONG_LOGIN_MESSAGE			14

#define NEW_USER				23

#define EX_ACCOUNT_INFORMATION			31

#define DATA_TO_UPDATE_SHARES			33

#define DELETE_RESPONSE				34

#define NEW_ACCOUNT_INFORMATION			35

#define NEW_ACCOUNT_INFORMATION_RESPONSE	50
#define EX_ACCOUNT_INFORMATION_RESPONSE		51
#define DELETE_REQUEST				52
#define PLAY_A_FILE_IN_LOCAL_DB			53
#define LOGIN_HASH_PREFIX			55


#define CONNECT_LISTEN 0
#define CONNECT_CONNECT 1


#include "AGMain.h"
#include "AGMessage.h"

void parseMessage(server_status &STATS, AGMessage* &TheMessage);

bool lookupLocalFileID(char* FileID, short FileIDLength, int FileSize);
//probably won't return bool when implemented

void handlePeerConnectingError(int newConnection, server_status &STATS);

int findConnectionRecordWithFileID(char* FileID, int FileIDLength, server_status &STATS);

void sendDeleteResponse(int i, server_status &STATS);

#endif



