/*
    error.h
    OpenAG, libOpenAG, OpenAG X
     
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    ************************************************************
    Parts of this file are based directly from code written by the late great 
    W. Richard Stevens -- Unix network programming god.
*/

 
#ifndef _AGERROR_H_
#define _AGERROR_H_
 
 /* SET THE DEBUG LEVEL 1 NUMBER HIGHER THAN WHAT YOU WANT TO SEE PRINTED */
 
 /* DEBUG LEVELS *
  * 0 - ONLY THINGS THAT WILL ALWAYS PRINT
  * 1 - troubleshooting info
  * 2 - major Status information
  * 3 - minor Status information
  * 4 - developer information
  * 5 - selected variable dumps
  * 6 ... ? */
 
// uncomment below to disallow sharing.
//#define SEND_NO_SHARES

//#define AGQUICKDOWNLOADTEST
//#define AUTOCONDENSEDATABASESONDELETE

#ifndef AGDEBUGLEVEL
    #define AGDEBUGLEVEL 1
#endif

#define AGDISPLAYDEBUGLEVEL 0

/* checks the debug level and prints the message  */

void print_debug(int level, const char *fmt, ...);

/* prints the error and exits  */

void err_exit(const char *fmt, ...);

/* prints the error, core dumps, and exits  */

void err_dump(const char *fmt, ...);

/* simply prints the error and returns  */

void err_print(const char *fmt, ...);

#endif


