/*
    darwin.cpp
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Wed Mar 20 2002.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    ****************
    
    This, and all other platform specific code sections are required
    by all modules and should be adapted per header-file specification
    to each individual platform.
*/

#include "common.h"

//#include "AGString.h"

#include "AGMain.h"
#include <errno.h>
#import <CoreFoundation/CFString.h>
#import <CoreFoundation/CFURL.h>

/* File Operations */

//open?

int AGMove(const char* PathFrom, const char* PathTo)
{
    errno = 0;
    if ((PathFrom == NULL) || (PathTo == NULL))
    {
        err_print("woh.  AGMove was passed a null pointer!\n That's no good.\n");
        return (-1); // defensive programming.
    }

    int size = PATH_MAX + PATH_MAX + 20;
    char* temp = new char[size];
    memset(temp, '\0', size);
    snprintf(temp, size, "mv \"%s\" \"%s\"", PathFrom, PathTo);
    int theReturn = 0;
    if (system(temp) != 0) theReturn = -1;
    delete(temp);
    
    return theReturn;

/*

    NSString *NSPathFrom = [[NSString stringWithCString:PathFrom] stringByStandardizingPath];
    NSString *NSPathTo = [[NSString stringWithCString:PathTo] stringByStandardizingPath];
    if ((NSPathFrom != nil) && ([NSPathFrom length] > 0) &&
        (NSPathTo != nil) && ([NSPathTo length] > 0)) // should prevent it from being nil or empty.
    {
        if ([[NSFileManager defaultManager]
            movePath:	NSPathFrom
            toPath:	NSPathTo
            handler:	nil])
                return 0;
        else
            return (-1);
    }
    else
        err_print("error moving from path: %s which resolved to: %s to path: %s which resolved to: %s\n",
                PathFrom, [NSPathFrom cString], PathTo, [NSPathTo cString]);
    return (-1);
    
    */
}

/*

AGString::AGString(unsigned char* theBuffer, unsigned short int type)
{
    if (theBuffer == NULL) return;
    
    CFStringEncoding theEncoding;
    
    switch(type)
    {
    case kAGServerEncoding:
        theEncoding = kCFStringEncodingWindowsLatin1;
        break;
    case kAGLocalDisplayEncoding:
    case kAGLocalFileSystemEncoding:
        theEncoding = kCFStringEncodingUTF8;
        // FIX --  kCFStringEncodingUTF8 should be OK  SOMEONE WHO KNOWS SOMETHING ABOUT THIS, PLEASE CHECK.
        break;
    default:
        err_exit("Improper use of AGString, you passed type: %i\n", type);
    }
    
    (CFStringRef)Data = CFStringCreateWithCString(NULL, (const char *)theBuffer, theEncoding);
}

AGString::~AGString()
{
    //if (Data != NULL)
    //    delete((CFStringRef)Data);
    [data release];
}

void AGString::getBufferWithEncoding(unsigned char*& theBuffer, int& length, unsigned short int type)
{
    if (theBuffer != NULL) delete(theBuffer);
    theBuffer = NULL;
    length = 0;
    if (Data == NULL) return;
    
    / * // should (hopefully) be handled by the maxBuf argument!
    if (type == kAGServerEncoding)
    {
        // Truncates, if needed!
        int adjust = 0;
        int temp = CFStringGetLength((CFStringRef)Data);
        if (temp > 255)
        {
            adjust = temp - 255;
            err_print("Converting Local string to Server String exceded 255 byte limit, truncating!\n");
        }
    }
    * /
    
    int adjust = 0;
    int temp = CFStringGetLength((CFStringRef)Data);
    int maxBuf;
    
    CFRange rangeToProcess = CFRangeMake(adjust, temp);
    
    CFStringEncoding theEncoding;
    
    switch(type)
    {
    case kAGServerEncoding:
        theEncoding = kCFStringEncodingWindowsLatin1;
        maxBuf = 255;
        break;
    case kAGLocalDisplayEncoding:
        maxBuf = 32000; // FIX -- we should figure out what this really should be.
        theEncoding = kCFStringEncodingUTF8;
        break;
    case kAGLocalFileSystemEncoding:
        maxBuf = PATH_MAX;
        theEncoding = kCFStringEncodingUTF8;
        break;
    default:
        err_exit("Improper use of AGString, you passed type: %i\n", type);
    }
    
    if (CFStringGetBytes((CFStringRef)Data, rangeToProcess, theEncoding, '?', false, NULL, maxBuf, &(CFIndex)length) < 0)
    {
        err_print("Could not convert string to encoding type: %i.  Returning NULL, the NULL string may cause bad things.\n", type);
        return;
    }
    
    theBuffer = new unsigned char[length+1];
    memset(theBuffer, '\0', length+1);
    
    CFStringGetBytes((CFStringRef)Data, rangeToProcess, theEncoding, '?', false, theBuffer, length, &(CFIndex)length);
    length++; // account for the \0
}

unsigned int AGString::length()
{
    return CFStringGetLength((CFStringRef)Data);
}
*/


/* These to functions MUST return a valid string of some type.
   Only NULL when the string passsed was NULL */

unsigned short int string_serverToLocal(unsigned char* &newString, unsigned const char* oldString, unsigned short int theLength)
{
    if (newString != NULL)
    {
        printf("passed a none-NULL buffer to string_serverToLocal... deleting\n");
        delete (newString);
    }
    newString = NULL;
    
    if (oldString == NULL)
        return 0;
    
    CFStringRef theCFString = CFStringCreateWithCString(NULL, (const char*)oldString, kCFStringEncodingWindowsLatin1);
    
    //CFStringRef theCFString = CFStringCreateWithBytes(NULL, oldString, theLength, kCFStringEncodingWindowsLatin1, false);
    
    if (theCFString == NULL)
    {
        err_print("******************* COULD NOT CONVERT STRING ************\n");
        return 0;
    }
    
    CFURLRef theCFURL = CFURLCreateWithFileSystemPath(NULL, theCFString, kCFURLPOSIXPathStyle, false);
    
    newString = new unsigned char[256];
    memset(newString, '\0', 256);
    
    if (CFURLGetFileSystemRepresentation(theCFURL, false, newString, 256) != true)
    {
        printf("FAILED TO GET CONVERSION via URL!");
        
        CFRange rangeToProcess = CFRangeMake(0, CFStringGetLength(theCFString));
        
        long newLength = 0;
        
        if (CFStringGetBytes(theCFString, rangeToProcess, kCFStringEncodingUTF8, '?', false, NULL, 255, &newLength) < 0)
        {
            err_print("Could not convert string from server to local.  Returning a copy of the passed string as the new string.  This could be very bad, as the unconverted string could cause crashes.\n");
            newString = (unsigned char*)strdup((const char*)oldString);
            return theLength;
        }
        
        newString = new unsigned char[newLength+1];
        memset(newString, '\0', newLength+1);
        
        CFStringGetBytes(theCFString, rangeToProcess, kCFStringEncodingUTF8, '?', false, newString, newLength, &newLength);
        newLength++; // account for the \0
    }
    
    //#if AGDEBUGLEVEL > 7
    printf("converted server string to local: %s\n", newString);
    //#endif
    
    CFRelease(theCFURL);
    CFRelease(theCFString);
    
    return strlen(newString);
}


/* This function must truncate if necessary ! */
unsigned short int string_localToServer(unsigned char* &newString, unsigned const char* oldString, unsigned short int theLength)
{
    #if AGDEBUGLEVEL > 7
    printf("about to convert local string: %s to server\n", oldString);
    #endif
    
    if (newString != NULL)
    {
        printf("passed a none-NULL buffer to string_serverToLocal... deleting\n");
        delete (newString);
    }
    newString = NULL;
    
    if (oldString == NULL)
        return 0;
    
    CFStringRef theCFString = CFStringCreateWithCString(NULL, (const char*)oldString, kCFStringEncodingUTF8);
    //CFStringRef theCFString = CFStringCreateWithBytes(NULL, oldString, theLength, kCFStringEncodingUTF8, false);
    
    if (theCFString == NULL)
    {
        err_print("******************* COULD NOT CONVERT STRING ************\n");
        return 0;
    }
    
    // Truncates, if needed!
    int adjust = 0;
    int temp = CFStringGetLength(theCFString);
    if (temp > 255)
    {
        adjust = temp - 255;
        err_print("Converting Local string to Server String exceded 255 byte limit, truncating!\n");
    }
    
    CFRange rangeToProcess = CFRangeMake(0, CFStringGetLength(theCFString));
    
    long newLength = 0;
    
    if (CFStringGetBytes(theCFString, rangeToProcess, kCFStringEncodingWindowsLatin1, '?', false, NULL, 255, &newLength) < 0)
    {
        err_print("Could not convert string from local to server.  Returning a copy of the oldstring.  This should not be a problem, but the unconverted string may cause an error on the server and cause it to drop the connection.\n");
        newString = (unsigned char*)strdup((const char*)oldString);
        return theLength;
    }
    
    newString = new unsigned char[newLength+1];
    memset(newString, '\0', newLength+1);
    
    CFStringGetBytes(theCFString, rangeToProcess, kCFStringEncodingWindowsLatin1, '?', false, newString, newLength, &newLength);
    newLength++; // account for the \0
    
    //printf("converted string: %s\n", newString);
    
    CFRelease(theCFString);
    
    return newLength;
}

