#include "PathConfig.hh"

#ifdef USE_GGI
#define GGITarget
#else
#undef GGITarget
#endif

#ifdef GGITarget
#include "GGI/GGIFrontBuffer.hh"
#include "GGI/GGIEvent.hh"
#include "PaintInterface/T1FontCreator.hh"
#else
#include "Xlib/XlibPaintInterface.hh"
#include "Xlib/XlibEvent.hh"
#include "Xlib/XlibFontCreator.hh"
#endif

#include "Client/WormApp.hh"
#include "Game/Players.hh"
#include "Network/NetConnector.hh"
#include "TaskSwitch.hh"
#include "MainGlobal.hh"
#include "Network/UDPConnection.hh"
#include "GraphConfig.hh"
#include "Picture.hh"
#include <stdlib.h>
#include <time.h>



int main(int argc, char ** argv)
{
  srand(time(0));
//  InstallErrorHandler();

  if ( ! global_TypePictures[0]->OK() )
    {
      fprintf(stderr, "Unable to load images, exiting.\n");
      exit(1);
    }

  // MainWindow
#ifndef GGITarget
  XlibMainWindow * mainw = new XlibMainWindow(argv, argc);
#endif
  // don't delete mainw, it's deleted in ~XlibFrontBuffer
  // FrameBuffers

#ifndef GGITarget
  XBuffer * xb = mainw->CreateXImage(); // deleted in ~FrontBuffer
  FrontBuffer * frontb = new XlibFrontBuffer(mainw, xb);
#else
  FrontBuffer * frontb = new GGIFrontBuffer;
#endif
  FrameBuffer * arena = new FrameBuffer(ttStore);
  FrameBuffer * scorepanel = new FrameBuffer(ttAlphaBlend);
  FrameBuffer * menu = new FrameBuffer(ttAlphaBlendDarker);
  frontb->AddFrameBuffer(arena);
  frontb->AddFrameBuffer(scorepanel);
  frontb->AddFrameBuffer(menu);

  // FontCreator
#ifndef GGITarget
  XPixmap * p = new XPixmap(mainw);
  FontCreator * fc = new XlibFontCreator(p, new XImageBuffer(p));
#else
  FontCreator * fc = new T1FontCreator;
#endif
  fontcreator = fc;

  Connection * connection = new UDPConnection(FALSE);
  
  NetConnector * network = new NetConnector(FALSE, connection, ScreenSizeX, ScreenSizeY);
  
  Players * players = new Players(arena, scorepanel, global_Background,
				  global_Wall, network);

#ifndef GGITarget  
  WormApp * app = new WormApp(frontb, menu, scorepanel,
			      new XlibEventManager(mainw), players, network);
#else
  WormApp * app = new WormApp(frontb, menu, scorepanel,
			      new GGIEventManager((GGIFrontBuffer *)frontb), players, network);
#endif
  
  TaskSwitch * ts = new TaskSwitch(app, players, frontb, network);
  
  ts->Run();
  
  delete ts;
  delete app;
  delete players;
  delete network;
  delete fc;
  delete arena;
  delete scorepanel;
  delete menu;
  delete frontb;
}
