#ifndef _WormApp_hh_
#define _WormApp_hh_

#include "XVision/Application.hh"

const CommandType cmHideMainMenu = 4000;
const CommandType cmStartGame = 4001;
const CommandType cmEndGame = 4002;
const CommandType cmContinueGame = 4003;
const CommandType cmQuit  = 4004;
const CommandType cmCreateServer = 4005;
const CommandType cmConnect = 4006;
const CommandType cmDisconnect = 4007;
const CommandType cmAboutClick = 4008;
const CommandType cmRootMenu = 4009;
const CommandType cmShowAbout = 4010;
const CommandType cmSendChatLine = 4011;

class Players;
class NetConnector;
class Menu;
class StaticText;
class InputLine;
class InputNumber;
class CheckBox;
class NetMessage;
class PlayerSelector;
class PlayerSelectorItem;
class ScoreTable;

class WormApp;

typedef void (WormApp:: *WormAppCallback_t)();

class WormApp : public Application {
  protected:
    NetConnector * network;
    Players * players;
    Menu * gamemenu, * startmenu, * mainmenu, * aboutmenu, * scoremenu;
    StaticText * connected_label;
    InputLine * server_hostname_label;
    InputNumber * server_port_label;
    InputNumber * worm_step_size_label, * worm_turn_size_label;
    InputNumber * speed_label, * rounds_label;
    CheckBox * option_surround_label, * option_show_score_label,
				      * option_show_fps_label;
    PlayerSelector * player_selector_group;
    InputLine * chat_line_send;
    StaticText * chat_line_recv;
    ScoreTable * scoretable;
    void SwitchMenu(bool Flip=TRUE, bool DoShow=TRUE);
    void ShowScore();
    void Quit();
    void CreateServer(bool OnlySetHostname=FALSE);
    void OptionsChanged(bool OnlyRequest, NetMessage * options);
    void StartGame(bool OnlyRequest);
    void EndGame(bool OnlyRequest);
    void StartRound(bool OnlyRequest);
    void EndRound(bool OnlyRequest);
    void EndRoundCallback1();
    void StartRoundCallback1();
    void StartRoundCallback2();    
    void SendPlayerCaptured(int ItemNum, PlayerSelectorItem * item);
    void RecvPlayerCaptured(NetMessage * msg);
    void SendChatLine();
    void RecvChatLine(const char * Text);
    bool JustStartedRound;
    int rounds, current_round;
    FrameBuffer * scorepanel;
    int LastFPSW, LastFPSH;
    bool ScorePanelVisible;
    int AlarmCounter;
    bool MenuVisible;
    int LastMsgW, LastMsgH;
    void RepaintScorePanel(bool show);
    WormAppCallback_t AlarmCallback;
    void TypeText(const char * text, Pixel_t bg_color, int WaitTime, WormAppCallback_t callback);
  public:
    WormApp(FrontBuffer * _front, FrameBuffer * _fb, FrameBuffer * _scorepanel,
	    EventManager * _evman, Players * _players, NetConnector * _network);
    void Initialize();
    bool HandleEvent(Event& event);
    void Connect();
    void Disconnect();
    void UpdateGame1();
    void UpdateGame2();
    void UpdateAlarm();
    bool ShowFPS;
    bool PlayingGame, ReallyPlaying; // Really => no StartRound || StartGame state
    int currentMaxFPS;
    int currentFPS;
    bool WantQuit;
    void PaintFPS();
};

const int init_FPS = 150;
const int min_FPS = 10;
const int max_FPS = 9999;

#endif

