#ifndef _Players_hh_
#define _Players_hh_

class Worm;
class Picture;
class NetConnector;
class FrameBuffer;

class Players {
  protected:
    Worm ** worms;
    FrameBuffer * arena, * scorepanel;
    Picture * background, * wallborder;
    int currentMaxPlayerNum;
    NetConnector * network;
    int score;
    void DeletePlayer(int number);
    void NewRoundPlayer(int number);
    void UpdateRemoteDeath();
    void UpdateLocalDeath();
    void UpdateScorePanel(int PlayerNumber);
    void KillAndUpdate(int Who, int ByWhom);
    void InitializeCrashBuffer();
    bool IsSurround;
  public:
    const int MAXPlayers = 100;
    Players(FrameBuffer * _arena, FrameBuffer * _scorepanel,
	    Picture * _background, Picture * _wallborder, NetConnector * _network);
    ~Players();
    int AddPlayer(Worm * player, int number=-1);
    void NewGame();
    void NewRound();
    void StepLocal();
    void StepRemote();
    void SendLocal();
    void UpdateRemote();
    void DrawAll();
    bool AllDead();
    Worm * GetPlayer(int playernum);
    int winner_num;
    void Surround(bool Set);
};

#endif
