#include "Worm.hh"
#include <math.h>
#include "Utils.hh"
#include "Filler.hh"
#include "FrameBuffer.hh"

#include <string.h>
// pro bzero
#include "Compat.hh"

int Worm::StepSize = 1;
int Worm::TurnSize = 3;

Worm::Worm(PlayerType_t _Type)
: number(-1), Xpos(0), Ypos(0),
  double_X(0), double_Y(0), double_radian_Angle(0),
  Lives(FALSE), fb(0), filler(0), step_counter(0),
  Name(0), KilledBy(0),
  linearPos(0), linearPosOld(0),  
  Angle(-1), Type(_Type)
{
}

Worm::~Worm()
{
  delete filler;
}

void Worm::NewGame()
{
  Score = 0;
}

static const int MinBorderGap = 50;

void Worm::NewRound(int sX=-1, int sY=-1, int sA=-1)
{
  if (!between(sA, 0, MAXAngle-1)) {
    int sa2 = Rand(MAXAngle); 
    sA = sa2;
  }
  SetAngle(sA);
  double newX;
  if (!between(sX, 0, PlaygroundXSize-1))
    newX = double(MinBorderGap + Rand(PlaygroundXSize-2*MinBorderGap));
  else
    newX = sX;
  double newY;
  if (!between(sY, 0, PlaygroundYSize-1))
    newY = double(MinBorderGap + Rand(PlaygroundYSize-2*MinBorderGap));
  else
    newY = sY;
  Move(newX, newY);
  // NOT DRAW!!!
  linearPosOld = linearPos;
  Lives = TRUE;
  step_counter = 1;
  KilledBy = 0;
}

void Worm::SetAngle(int _Angle)
{
  if (Angle == _Angle)
    return;
  if (_Angle < 0)
    _Angle += MAXAngle;
  if (_Angle >= MAXAngle)
    _Angle -= MAXAngle;
  Angle = _Angle;
  double_radian_Angle = (double(Angle)/double(MAXAngle))*2*PI;
  double_Shift_X = cos(double_radian_Angle)*StepSize;
  double_Shift_Y = sin(double_radian_Angle)*StepSize;
}

void Worm::TurnLeft()
{
  SetDir(DirTurnLeft);
  SetAngle(Angle-TurnSize);
}

void Worm::TurnRight()
{
  SetDir(DirTurnRight);
  SetAngle(Angle+TurnSize);
}

void Worm::Move(const double newX, const double newY)
{
  double_X = newX;
  double_Y = newY;
  if (double_X < 0)
    double_X = PlaygroundXSize - filler->ImageSize - 1;
  if (double_X > (PlaygroundXSize - filler->ImageSize - 1))
    double_X = 0;
  if (double_Y < 0)
    double_Y = PlaygroundYSize - filler->ImageSize - 1;
  if (double_Y > (PlaygroundYSize - filler->ImageSize - 1))
    double_Y = 0;
  Xpos = int(floor(double_X));
  Ypos = int(floor((double_Y)));
  linearPosOld = linearPos;
  linearPos = Xpos + Ypos*PlaygroundXSize;
}

void Worm::Step()
{
  if (!Lives)
    return;
  int oldsAngle = Angle;
  Control();
  if (oldsAngle == Angle)
    SetDir(DirUnpress);
  Move(double_X + double_Shift_X,
       double_Y + double_Shift_Y);
  DetectCrash();
  Draw();
}

void Worm::Draw()
{
  Pixel_t * gi = filler->GetImage(Xpos, Ypos);
  fb->PutImage(Xpos, Ypos, filler->ImageSize, filler->ImageSize,
	       gi, filler->ImageWidth);
  int sz = filler->ImageSize;

  CrashBufferItem_t * cbi = &(*crashBuffer)[linearPos];
  for (int i=0; i<sz; i++, cbi += PlaygroundXSize-sz)
    for (int j=0; j<sz; j++, cbi++) {
      cbi->PlayerNumber = number;
      cbi->Counter = step_counter;
    }
  step_counter++;
}

void Worm::DetectCrash()
{
  int sz = filler->ImageSize;

  CrashBufferItem_t * cbi = &(*crashBuffer)[linearPos];
  for (int i=0; i<sz; i++, cbi += PlaygroundXSize-sz)
    for (int j=0; j<sz; j++, cbi++) {
      int nmb = cbi->PlayerNumber;
      if (!nmb)
	continue;
      int cnt = cbi->Counter;
      // 10 steps backwards can be at current position and
      // it won't be death
      if ((nmb != number) || (cnt < step_counter-10)) {
	KilledBy = (nmb == WallBorderCrashB_playernum ? number : nmb);
	Death();
	return;
      }
  }
}

void Worm::Death()
{
//  PrintErr << "death: " << (number-1) << " by " << (KilledBy-1) << nl;
  Lives = FALSE;
}

bool Worm::IsLive()
{
  return Lives;
}

void Worm::SetFiller(Filler * _newf)
{
  delete filler;
  filler = _newf;
};

static const char worm_nullstring[] = "";
const char * Worm::GetName()
{
  if (Name)
    return Name;
  else
    return worm_nullstring;
}

void Worm::SetName(const char * _Name)
{
  if (Name) 
    delete Name;
  Name = new char[(_Name ? strlen(_Name) : 0)+1];
  if (_Name)
    strcpy(Name, _Name);
  else
    Name[0] = 0;
}

void Worm::SetDir(int newDir)
{
  if (newDir == Dir)
    return;
  Dir = newDir;
  DirChanged = TRUE;
}

bool Worm::GetDirChanged()
{
  if (!DirChanged)
    return FALSE;
  DirChanged = FALSE;
  return TRUE;
};

void Worm::AddPoints(int points)
{
  Score += points;
}
