#ifndef _Worm_hh_
#define _Worm_hh_

#include "PlayerType.hh"
#include "FrameBuffer.hh"
class Filler;

const int PlayerType_t_count = 4;


class Worm {
  private:
    int number; // 0 is invalid!!!
    int Score;
    int Xpos, Ypos;
    double double_X, double_Y;
    double double_radian_Angle;
    double double_Shift_X, double_Shift_Y;
    bool Lives;
    FrameBuffer * fb;
    Filler * filler;
    int step_counter;
    char * Name;
    int KilledBy;
    void DetectCrash();
    void Move(const double newX, const double newY);
    void SetAngle(int _Angle);
  protected:
    int linearPos, linearPosOld;
    int Angle; // 0 - MAXAngle
    PlayerType_t Type;
    void TurnLeft();
    void TurnRight();
    virtual void Control()=0;
    Worm(PlayerType_t _Type);
    static const int DirTurnLeft = 0;
    static const int DirUnpress = 1;
    static const int DirTurnRight = 2; // must be same as in NetMessage.hh!!!
    void SetDir(int newDir);
    int Dir;
    bool DirChanged;
  public:
    static int StepSize;
    static const int MinStepSize = 1;
    static const int MaxStepSize = 3;    
    static int TurnSize;
    static const int MinTurnSize = 1;
    static const int MaxTurnSize = 15;        
    static const int MAXAngle = 512;
    static const int PlaygroundYSize = FrameBuffer::WindowSizeY;
    static const int PlaygroundXSize = FrameBuffer::WindowSizeX;
    void SetFrameBuffer(FrameBuffer * _fb) { fb = _fb; };
    void SetNumber(int _number) { number = _number; };
    void SetFiller(Filler * _newf);
    void SetName(const char * _Name);
    const char * GetName();
    PlayerType_t GetType() { return Type; };
    bool IsRemote() { return Type == ptNetwork; };
    Filler * GetFiller() { return filler; };
    virtual void NewGame();
    virtual void NewRound(int sX=-1, int sY=-1, int sA=-1);
    void Death();
    virtual ~Worm();
    void Step();
    void Draw();
    void Kill();
    bool IsLive();
    int GetDir() { return Dir; };
    bool GetDirChanged();
    void GetPos(int& storeX, int& storeY, int& storeAngle) { storeX = Xpos; storeY = Ypos; storeAngle = Angle; };
    int GetScore() { return Score; };
    void AddPoints(int points);
    int GetKilledBy() { int k = KilledBy; KilledBy = 0; return k; };
};

struct CrashBufferItem_t {
  char PlayerNumber; //0-254, eg. enough for Players::MAXPlayers
  unsigned short int Counter;    // see Players::Surround() if you change this!
};

const char WallBorderCrashB_playernum = 0xff;
const char VoidCrashB_playernum = 0;

const int CrashBufferSize =
  Worm::PlaygroundYSize*Worm::PlaygroundXSize;
typedef CrashBufferItem_t CrashBuffer_t[CrashBufferSize];
extern CrashBuffer_t * crashBuffer; // defined in Players.cc

#endif

