#include "NetCTree.hh"
#include "Utils.hh"

class NetCNode {
  public:
    NetMessage * data;
    NetCNode * next;
    NetCNode(NetMessage * _data) : data(_data), next(0) { };
};

class NetCItem {
  NetCNode * first, * last;
  public:
    NetCItem() : first(0), last(0) { };
    void AddNode(NetMessage * data);
    NetMessage * GetNode();
    void DeleteMessages();
};


void NetCItem::AddNode(NetMessage * data)
{
  NetCNode * n = new NetCNode(data);
  if (last)
    last->next = n;
  else
    first = n;
  last = n;
}

NetMessage * NetCItem::GetNode()
{
  if (first) {
    NetCNode * n = first;
    first = n->next;
    if (!first)
      last = 0;
    NetMessage * data = n->data;
    delete n;
    return data;
  }
  return 0;
}

void NetCItem::DeleteMessages()
{
  NetCNode * n = first;
  while (n) {
    NetCNode * n2 = n->next;
    delete n;
    n = n2;
  }
  first = 0;
  last = 0;
}

NetCTree::NetCTree()
{
  for (int i=0; i<MsgType_t_count; i++)
    items[i] = new NetCItem();
}

NetCTree::~NetCTree()
{
  for (int i=0; i<MsgType_t_count; i++)
    delete items[i];
}

void NetCTree::PutMessages(void * buffer, int bufsize)
{
  char * p = (char *) buffer;
  int i = 0;
  while (i<bufsize) {
    NetMessage * n = (NetMessage *) p;
    // there should be change byte order...
//    PrintErr << "msg: " << n->type;
    int size = n->size;
    char * b = new char[size];
    memcpy(b, n, size);
    items[n->type]->AddNode((NetMessage *) b);
    i += size;
    p += size;
  }
//  PrintErr << "end" << nl;
}

NetMessage * NetCTree::GetMsg(MsgType_t type)
{
  return items[type]->GetNode();
}

void NetCTree::DeleteMessages()
{
  for (int i=0; i<MsgType_t_count; i++)
    items[i]->DeleteMessages();
}
