#ifndef _NetConnector_hh_
#define _NetConnector_hh_

#include "Compat.hh"

#include "NetMessage.hh"
#include "Connection.hh"

class NetCTree;

class NetConnector {
  public:
    Connection * connection;
  protected:
    NetCTree * tree;
    char * out_buffer, * in_buffer;
    char * save_out_buffer1, * cached_in_buffer;
    int bufpos, save_bufsize1, cached_bufsize;
    StdInteger PacketCounter;
    bool AlreadyReceived, AlreadySent;
    int WaitCounter;
    bool IsServer;
    static const int buffersize = 16000; // should be enough...
    static const int bufstart = sizeof(PacketHeader);
    void ProcessMessages();
    int ScreenSizeX, ScreenSizeY;
  public:
    NetConnector(bool _IsServer, Connection * _connection,
    int _ScreenSizeX, int _ScreenSizeY);
    ~NetConnector();
    bool Connect();
    bool Disconnect();
    void SendMsg(NetMessage * msg);
    NetMessage * GetMsg(MsgType_t type);
    bool ReceiveMessages(bool Wait);
    bool ReceiveMessagesWaitMore();    
    void ResendMessages();
    bool SendMessages();
    void DeleteMessages();
    void Reset();
    bool NetworkGame() { return connection->IsConnected(); };
    char * status;
};

#endif
