#ifndef _NetworkTimings_hh_
#define _NetworkTimings_hh_

const int ServerDefaultPort = 13333; // uh, not exactly timings :-)

// NetConnector:
const int NetConnectorInitTries = 2; // max tries in NetConnector::Connect
const int NetConnectorSendTries = 10; // SendMessages() - max tries to send
const int NetConnectorRecvTimeout = 15; // ReceiveMessages(TRUE) - time is UDPConnectionTimeout*RecvTimeout
const int NetConnectorRecvTries = 15; // ReceiveMessagesWaitMore - time is UDPConnectionTimeout*RecvTimeout*RecvTries

// Multiplexor:
const int MultiplexorConnectionTimeout = 10000; // (initial/dynamic) timeout for select(2) in WaitForConnection

// UDPConnection:
const int UDPConnectionTimeout = 10000; // (initial/dynamic) in u_sec, timeout while waiting for message in UDPConnection::Receive with Wait=TRUE
const int UDPConnectionSendRecTryCount = 20; // max loops in UDPConnection::SendReceive

// GameServer:
const int GameServerInitCheckCounter = 10; // how often server checks for new connections
const int GameServerIdleSleepTime = 1000000; // in u-sec, sleep time when there are no clients
const int GameServerRecvTimeoutC = NetConnectorRecvTimeout; // * frametime => timeout, after are send messages again
const int GameServerInitFrameTime = 20000; // initial (first client) CollectMessages timeout

const int usec2sec = 1000000; // 1000000 usec == 1 sec

const int TaskSwitchTimeout = 15*usec2sec; // time, after client disconnects from server
const int GameServerTimeout = 10*usec2sec; // time, after server kills 'dead' clients

const bool NetworkShowWarnings = TRUE; //FALSE;

#endif
