#include "Event.hh"
#include "Utils.hh"

EventManager * global_EventManager = 0;

Event::~Event()
{
  delete next;
}

EventManager::EventManager()
    : first(0), last(0)
{
  global_EventManager = this;
  for (int i=0; i<ktMAX; i++)
    keyp[i] = FALSE;
};

Event* EventManager::Get()
{
  if (!first) {
    first = New();
    if (!first)
      return 0;
  }
  Event * tmp = first;
  first = first->next;
  if (last == tmp)
    last = 0;
  tmp->next = 0;
  return tmp;
}

void EventManager::Put(Event& ev)
{
  Event * e = new Event(ev);
  if (last)
    last->next = e;
  else
    first = e;
  last = e;
}

void EventManager::PutFirst(Event& ev)
{
  Event * e = new Event(ev);
  e->next = first;
  if (!last)
    last = e;
  first = e;
}

bool Event::KeyPrintable()
{
  if (between(key, ktTable1Start, ktTable1End))
    return TRUE;
  if (between(key, ktOtherPrintableStart, ktOtherPrintableEnd))
    return TRUE;
  return FALSE;
}

static const char * KeyStringsTable1[] = {
  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
  "kp 0", "kp 1", "kp 2", "kp 3", "kp 4", "kp 5", "kp 6", "kp 7", "kp 8", "kp 9",
  "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P",
  "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
  "<space>" };

static const char * KeyStringsTable2[] = {
  "down", "up", "left", "right",
  "Enter", "Esc", "Tab", "Caps Lock",
  "Left Shift", "Left Control", "Left Alt",
  "Mode Switch",
  "Right Alt", "Right Control", "Right Shift",
  "Backspace",
  "Insert", "Home", "Page Up", "Delete", "End", "Page Down",
  "kp Enter",
  "Left Meta", "Right Meta",
  "Num Lock",
  "kp /", "kp *", "kp -", "kp +",
  "kp Home", "kp End", "kp Page Up", "kp Page Down",
  "kp Up", "kp Down", "kp Left", "kp Right",
  "kp Begin", "kp Insert", "kp Delete"				 
};

static char ret_getksprint[2] = " ";
static char ret_getksfxx[4] = "Fxx";
static char ret_getksmouse[10] = "mb xx";
static char ret_getkserr[] = "error";
static char ret_getksunknown[] = "key xxx";

const char * Event::GetKeyString()
{
  if (between(key, ktTable1Start, ktTable1End))
    return KeyStringsTable1[key-ktTable1Start];
  if (between(key, ktOtherPrintableStart, ktOtherPrintableEnd)) {
    ret_getksprint[0] = key - ktOtherPrintableStart;
    return ret_getksprint;
  }
  if (between(key, ktTable2Start, ktTable2End))
    return KeyStringsTable2[key-ktTable2Start];
  if ((ktFxxStart <= key) && (key <= ktFxxEnd)) {
    int f = (key-ktFxxStart);
    if (f<10) {
      ret_getksfxx[1] = f + '0';
      ret_getksfxx[2] = 0;
    } else {
      ret_getksfxx[1] = (f/10) + '0';
      ret_getksfxx[2] = (f%10) + '0';
    }
    return ret_getksfxx;
  }
  if (between(key, ktMouseButtonStart, ktMouseButtonEnd)) {
    int f = (key-ktMouseButtonStart);
    if (f<10) {
      ret_getksmouse[3] = f + '0';
      ret_getksmouse[4] = 0;
    } else {
      ret_getksmouse[3] = (f/10) + '0';
      ret_getksmouse[4] = (f%10) + '0';
    }
    return ret_getksmouse;
  }
  if (between(key, ktNoSymbolStart, ktNoSymbolEnd)) {
    int f = (key-ktNoSymbolStart);
    ret_getksunknown[4] = (f/100) + '0';
    ret_getksunknown[5] = ((f/10)%10) + '0';
    ret_getksunknown[6] = (f%10) + '0';    
    return ret_getksunknown;
  }
  return ret_getkserr;
}
