#include "FontCreator.hh"

FontCreator * fontcreator = 0;

Pixel_t * FontCreator::CreateFontImage(const char * text, Pixel_t color,
				       TextDirection direction, FontShape fontshape, int& W, int& H)
{
  Pixel_t * b = CreateNorthFontImage(text, color, fontshape, W, H);
  if (direction == tdNorth)
    return b;
  Pixel_t * b2 = new Pixel_t[W*H];
  Pixel_t * bs = b;  
  switch (direction) {
  case tdSouth:
    {
      Pixel_t * b2s = b2+W*H;
      for (int i=0; i<H*W; i++)
	*(b2s--) = *(bs++);
    }
    break;    
  case tdEast:
    for (int i=0; i<H; i++)
      for (int j=0; j<W; j++)
	b2[H-1-i+H*j] = *(bs++);
    {
      int t = W;
      W = H;
      H = t;
    }
    break;
  default: //case tdWest:
    for (int i=0; i<H; i++)
      for (int j=0; j<W; j++)
	b2[i+H*(W-1-j)] = *(bs++);
    {
      int t = W;
      W = H;
      H = t;
    }
  }
  delete b;
  return b2;
}
