#ifndef _Application_hh_
#define _Application_hh_

#include "Group.hh"

class FrontBuffer;

class Application : public Group {
  protected:
    EventManager * evman;
    FrontBuffer * front;
    FrameBuffer * fb_save;
    int fbstop_count;
    int rearrange_count;
    void Center();
  public:
    FrameBuffer * fb;
    bool CanReArrange;
    Application(FrontBuffer * _front, FrameBuffer * _fb, EventManager * _evman,
		const Align _align=VAVertical);
    ~Application();
    void CreateEvent(Event& ev);
    virtual void Initialize();
    bool Run();
    bool HandleEvent(Event& event);
    void StartRedraw() { if (!(--fbstop_count)) fb = fb_save; };
    void StopRedraw() { fb = 0; fbstop_count++; };
    void StartReArrange() { if (!(--rearrange_count)) CanReArrange = TRUE; };
    void StopReArrange() {  rearrange_count++; CanReArrange = FALSE; };
    virtual void ReArrange(bool CallParent=TRUE, View * except=0);
};

extern Application * app_global;

#endif

